/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.core.JavaPsiBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import gnu.trove.TIntObjectHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;

public final class ElementPresentationUtil
implements PlatformIcons {
    public static final int CLASS_KIND_CLASS = 30;
    public static final int CLASS_KIND_JSP = 70;
    public static final int CLASS_KIND_EXCEPTION = 80;
    public static final int FLAGS_RUNNABLE = 16384;
    private static final Key<CachedValue<Integer>> CLASS_KIND_KEY = new Key("CLASS_KIND_KEY");
    private static final TIntObjectHashMap<Icon> BASE_ICON = new TIntObjectHashMap(20);

    private ElementPresentationUtil() {
    }

    public static int getFlags(PsiModifierListOwner element, boolean isLocked) {
        boolean isEnum = element instanceof PsiClass && ((PsiClass)element).isEnum();
        int flags = (element.hasModifierProperty("final") && !isEnum ? 1024 : 0) | (element.hasModifierProperty("static") && !isEnum ? 512 : 0) | (isLocked ? 2048 : 0);
        if (element instanceof PsiClass) {
            int kind;
            PsiClass aClass = (PsiClass)element;
            if (element.hasModifierProperty("abstract") && !((PsiClass)element).isInterface()) {
                flags |= 0x100;
            }
            if ((kind = ElementPresentationUtil.getClassKind(aClass)) == 90) {
                flags |= 0x2000;
            } else if (kind == 100) {
                flags |= 0x4000;
            }
        }
        return flags;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static com.intellij.ui.RowIcon createLayeredIcon(Icon baseIcon, PsiModifierListOwner element, boolean isLocked) {
        return (com.intellij.ui.RowIcon)IconManager.getInstance().createLayeredIcon(element, baseIcon, ElementPresentationUtil.getFlags(element, isLocked));
    }

    public static int getBasicClassKind(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isRecord()) {
            return 110;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        return 30;
    }

    public static int getClassKind(PsiClass aClass) {
        if (!aClass.isValid()) {
            aClass.putUserData(CLASS_KIND_KEY, null);
            return 30;
        }
        CachedValue<Integer> value2 = aClass.getUserData(CLASS_KIND_KEY);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager(aClass.getProject()).createCachedValue(() -> CachedValueProvider.Result.createSingleDependency(ElementPresentationUtil.getClassKindImpl(aClass), aClass), false);
            aClass.putUserData(CLASS_KIND_KEY, value2);
        }
        return value2.getValue();
    }

    private static int getClassKindImpl(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isRecord()) {
            return 110;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        if (!DumbService.getInstance(aClass.getProject()).isDumb()) {
            boolean isException;
            PsiManager manager = aClass.getManager();
            PsiClass javaLangTrowable = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope());
            boolean bl = isException = javaLangTrowable != null && InheritanceUtil.isInheritorOrSelf(aClass, javaLangTrowable, true);
            if (isException) {
                return 80;
            }
            if (TestFrameworks.getInstance().isTestClass(aClass)) {
                return 90;
            }
            if (PsiClassUtil.isRunnableClass(aClass, false) && PsiMethodUtil.findMainMethod(aClass) != null) {
                return 100;
            }
        }
        return 30;
    }

    public static Icon getClassIconOfKind(PsiClass aClass, int classKind) {
        boolean isAbstract = aClass.hasModifierProperty("abstract");
        return (Icon)BASE_ICON.get(classKind | (isAbstract ? 256 : 0));
    }

    public static String getDescription(PsiModifierListOwner member2) {
        String noun;
        if (member2 instanceof PsiClass) {
            noun = ElementPresentationUtil.getClassNoun((PsiClass)member2);
        } else if (member2 instanceof PsiMethod) {
            noun = JavaPsiBundle.message("node.method.tooltip", new Object[0]);
        } else if (member2 instanceof PsiField) {
            noun = JavaPsiBundle.message("node.field.tooltip", new Object[0]);
        } else {
            return null;
        }
        String adj = ElementPresentationUtil.getFlagsDescription(member2);
        return (adj + " " + noun).trim();
    }

    private static String getClassNoun(PsiClass aClass) {
        String noun;
        int kind = ElementPresentationUtil.getClassKind(aClass);
        switch (kind) {
            case 20: {
                noun = JavaPsiBundle.message("node.annotation.tooltip", new Object[0]);
                break;
            }
            case 40: {
                noun = JavaPsiBundle.message("node.anonymous.class.tooltip", new Object[0]);
                break;
            }
            case 50: {
                noun = JavaPsiBundle.message("node.enum.tooltip", new Object[0]);
                break;
            }
            case 110: {
                noun = JavaPsiBundle.message("node.record.tooltip", new Object[0]);
                break;
            }
            case 80: {
                noun = JavaPsiBundle.message("node.exception.tooltip", new Object[0]);
                break;
            }
            case 10: {
                noun = JavaPsiBundle.message("node.interface.tooltip", new Object[0]);
                break;
            }
            case 90: {
                noun = JavaPsiBundle.message("node.junit.test.tooltip", new Object[0]);
                break;
            }
            case 100: {
                noun = JavaPsiBundle.message("node.runnable.class.tooltip", new Object[0]);
                break;
            }
            default: {
                noun = JavaPsiBundle.message("node.class.tooltip", new Object[0]);
            }
        }
        return noun;
    }

    private static String getFlagsDescription(PsiModifierListOwner aClass) {
        int level;
        PsiModifierList list2;
        int flags = ElementPresentationUtil.getFlags(aClass, false);
        StringBuilder adj = new StringBuilder();
        for (IconLayerProvider provider2 : IconLayerProvider.EP_NAME.getExtensionList()) {
            if (provider2.getLayerIcon(aClass, false) == null) continue;
            adj.append(" ").append(provider2.getLayerDescription());
        }
        if (BitUtil.isSet(flags, 256)) {
            adj.append(" ").append(JavaPsiBundle.message("node.abstract.flag.tooltip", new Object[0]));
        }
        if (BitUtil.isSet(flags, 1024)) {
            adj.append(" ").append(JavaPsiBundle.message("node.final.flag.tooltip", new Object[0]));
        }
        if (BitUtil.isSet(flags, 512)) {
            adj.append(" ").append(JavaPsiBundle.message("node.static.flag.tooltip", new Object[0]));
        }
        if ((list2 = aClass.getModifierList()) != null && (level = PsiUtil.getAccessLevel(list2)) != 4) {
            adj.append(" ").append(StringUtil.capitalize(JavaPsiBundle.visibilityPresentation(PsiUtil.getAccessModifier(level))));
        }
        return adj.toString();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Icon addVisibilityIcon(PsiModifierListOwner element, int flags, com.intellij.ui.RowIcon baseIcon) {
        return ElementPresentationUtil.addVisibilityIcon(element, flags, (RowIcon)baseIcon);
    }

    public static Icon addVisibilityIcon(PsiModifierListOwner element, int flags, RowIcon baseIcon) {
        if (BitUtil.isSet(flags, 1)) {
            VisibilityIcons.setVisibilityIcon(element.getModifierList(), baseIcon);
        }
        return baseIcon;
    }

    static {
        BASE_ICON.put(30, (Object)IconWithToolTip.tooltipOnlyIfComposite((Icon)CLASS_ICON));
        BASE_ICON.put(286, (Object)ABSTRACT_CLASS_ICON);
        BASE_ICON.put(20, (Object)ANNOTATION_TYPE_ICON);
        BASE_ICON.put(276, (Object)ANNOTATION_TYPE_ICON);
        BASE_ICON.put(40, (Object)ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(296, (Object)ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(60, (Object)ASPECT_ICON);
        BASE_ICON.put(316, (Object)ASPECT_ICON);
        BASE_ICON.put(50, (Object)ENUM_ICON);
        BASE_ICON.put(306, (Object)ENUM_ICON);
        BASE_ICON.put(80, (Object)EXCEPTION_CLASS_ICON);
        BASE_ICON.put(336, (Object)AllIcons.Nodes.AbstractException);
        BASE_ICON.put(10, (Object)IconWithToolTip.tooltipOnlyIfComposite((Icon)INTERFACE_ICON));
        BASE_ICON.put(266, (Object)IconWithToolTip.tooltipOnlyIfComposite((Icon)INTERFACE_ICON));
        BASE_ICON.put(90, (Object)IconWithToolTip.tooltipOnlyIfComposite((Icon)CLASS_ICON));
        BASE_ICON.put(346, (Object)ABSTRACT_CLASS_ICON);
        BASE_ICON.put(110, (Object)RECORD_ICON);
        BASE_ICON.put(100, (Object)CLASS_ICON);
        IconManager iconManager = IconManager.getInstance();
        iconManager.registerIconLayer(512, AllIcons.Nodes.StaticMark);
        iconManager.registerIconLayer(1024, AllIcons.Nodes.FinalMark);
        iconManager.registerIconLayer(8192, AllIcons.Nodes.JunitTestMark);
        iconManager.registerIconLayer(16384, AllIcons.Nodes.RunnableMark);
    }
}

