/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/library/impl/SimpleIrTableFileWriter;", "", "tableName", "", "itemsCount", "", "(Ljava/lang/String;I)V", "currentItemIndex", "currentPosition", "file", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getItemsCount", "()I", "randomAccessFile", "Ljava/io/RandomAccessFile;", "getTableName", "()Ljava/lang/String;", "addItem", "", "bytes", "", "finishWriting", "kotlin-util-klib"})
public final class SimpleIrTableFileWriter {
    private int currentItemIndex;
    private int currentPosition;
    private final File file;
    private final RandomAccessFile randomAccessFile;
    @NotNull
    private final String tableName;
    private final int itemsCount;

    public final void addItem(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        this.randomAccessFile.seek(this.currentItemIndex * 4 + 4);
        this.randomAccessFile.writeInt(bytes.length);
        this.randomAccessFile.seek(this.currentPosition);
        this.randomAccessFile.write(bytes);
        int n = this.randomAccessFile.getFilePointer() < (long)Integer.MAX_VALUE ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.currentPosition = (int)this.randomAccessFile.getFilePointer();
        n = this.currentItemIndex;
        this.currentItemIndex = n + 1;
    }

    @NotNull
    public final File finishWriting() {
        boolean bl = this.currentItemIndex == this.itemsCount;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Expected: " + this.itemsCount + ", but was: " + this.currentItemIndex;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.randomAccessFile.close();
        File file2 = this.file;
        Intrinsics.checkExpressionValueIsNotNull(file2, "file");
        return file2;
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    public final int getItemsCount() {
        return this.itemsCount;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleIrTableFileWriter(@NotNull String tableName, int itemsCount) {
        Intrinsics.checkParameterIsNotNull(tableName, "tableName");
        this.tableName = tableName;
        this.itemsCount = itemsCount;
        File file2 = this.file = Files.createTempFile(this.tableName, "", new FileAttribute[0]).toFile();
        Intrinsics.checkExpressionValueIsNotNull(file2, "file");
        this.randomAccessFile = new RandomAccessFile(file2.getPath(), "rw");
        this.randomAccessFile.writeInt(this.itemsCount);
        int n = (int)this.randomAccessFile.getFilePointer() == 4 ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl2 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = 0;
        n2 = this.itemsCount;
        while (n < n2) {
            void i;
            this.randomAccessFile.writeInt(-1);
            ++i;
        }
        this.currentPosition = (int)this.randomAccessFile.getFilePointer();
        n = this.currentPosition == 4 + 4 * this.itemsCount ? 1 : 0;
        n2 = 0;
        bl = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

