/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirNamedReference;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.FirSuperReference;
import org.jetbrains.kotlin.fir.FirTarget;
import org.jetbrains.kotlin.fir.FirThisReference;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationContainer;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationWithBody;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirNamedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirArraySetCall;
import org.jetbrains.kotlin.fir.expressions.FirAssignment;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirBreakExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirClassReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirContinueExpression;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirThrowExpression;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirUncheckedNotNullCast;
import org.jetbrains.kotlin.fir.expressions.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.expressions.impl.FirExpressionStub;
import org.jetbrains.kotlin.fir.expressions.impl.FirLoopJump;
import org.jetbrains.kotlin.fir.expressions.impl.FirUnitExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.symbols.ConeCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirDelegatedTypeRef;
import org.jetbrains.kotlin.fir.types.FirDynamicTypeRef;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRefWithNullability;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d4\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J!\u0010\r\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\u0014\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020:H\u0016J&\u0010;\u001a\u00020\u000b\"\u000e\b\u0000\u0010<*\b\u0012\u0004\u0012\u0002H<0=2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H<0=H\u0016J\u0010\u0010?\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020GH\u0016J\u001c\u0010H\u001a\u00020\u000b\"\u0004\b\u0000\u0010I2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0KH\u0016J\u0010\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\u000b2\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\u000b2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\u000b2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u000b2\u0006\u0010\\\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020\u000b2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020\u000b2\u0006\u0010b\u001a\u00020cH\u0016J\u0010\u0010d\u001a\u00020\u000b2\u0006\u0010e\u001a\u00020fH\u0016J\u0010\u0010g\u001a\u00020\u000b2\u0006\u0010h\u001a\u00020iH\u0016J\u0010\u0010j\u001a\u00020\u000b2\u0006\u0010k\u001a\u00020lH\u0016J\u0010\u0010m\u001a\u00020\u000b2\u0006\u0010n\u001a\u00020oH\u0016J\u0010\u0010p\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020rH\u0016J\u0010\u0010s\u001a\u00020\u000b2\u0006\u0010t\u001a\u00020uH\u0016J\u0010\u0010v\u001a\u00020\u000b2\u0006\u0010w\u001a\u00020xH\u0016J\u0010\u0010y\u001a\u00020\u000b2\u0006\u0010z\u001a\u00020{H\u0016J\u0010\u0010|\u001a\u00020\u000b2\u0006\u0010}\u001a\u00020~H\u0016J\u0012\u0010\u007f\u001a\u00020\u000b2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0016J\u0013\u0010\u0082\u0001\u001a\u00020\u000b2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0016J\u0013\u0010\u0085\u0001\u001a\u00020\u000b2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0016J\u0013\u0010\u0088\u0001\u001a\u00020\u000b2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J\u0013\u0010\u008b\u0001\u001a\u00020\u000b2\b\u0010\u008c\u0001\u001a\u00030\u008d\u0001H\u0016J\u0013\u0010\u008e\u0001\u001a\u00020\u000b2\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0016J\u0013\u0010\u0091\u0001\u001a\u00020\u000b2\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0016J\u0013\u0010\u0094\u0001\u001a\u00020\u000b2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0016J\u0013\u0010\u0097\u0001\u001a\u00020\u000b2\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0016J\u0013\u0010\u009a\u0001\u001a\u00020\u000b2\b\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0016J\u0013\u0010\u009d\u0001\u001a\u00020\u000b2\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0016J\u0013\u0010\u00a0\u0001\u001a\u00020\u000b2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001H\u0016J\u0013\u0010\u00a3\u0001\u001a\u00020\u000b2\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001H\u0016J\u0013\u0010\u00a6\u0001\u001a\u00020\u000b2\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001H\u0016J\u0013\u0010\u00a9\u0001\u001a\u00020\u000b2\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u0001H\u0016J\u0013\u0010\u00ac\u0001\u001a\u00020\u000b2\b\u0010\u00ad\u0001\u001a\u00030\u00ae\u0001H\u0016J\u0011\u0010\u00af\u0001\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u00b0\u0001\u001a\u00020\u000b2\b\u0010\u00b1\u0001\u001a\u00030\u00b2\u0001H\u0016J\u0013\u0010\u00b3\u0001\u001a\u00020\u000b2\b\u0010\u00b4\u0001\u001a\u00030\u00b5\u0001H\u0016J\u0013\u0010\u00b6\u0001\u001a\u00020\u000b2\b\u0010\u00b7\u0001\u001a\u00030\u00b8\u0001H\u0016J\u0013\u0010\u00b9\u0001\u001a\u00020\u000b2\b\u0010\u00ba\u0001\u001a\u00030\u00bb\u0001H\u0016J\u0013\u0010\u00bc\u0001\u001a\u00020\u000b2\b\u0010\u00bd\u0001\u001a\u00030\u00be\u0001H\u0016J\u0013\u0010\u00bf\u0001\u001a\u00020\u000b2\b\u0010\u00c0\u0001\u001a\u00030\u00c1\u0001H\u0016J\u0013\u0010\u00c2\u0001\u001a\u00020\u000b2\b\u0010\u00c3\u0001\u001a\u00030\u00c4\u0001H\u0016J\u0013\u0010\u00c5\u0001\u001a\u00020\u000b2\b\u0010\u00c6\u0001\u001a\u00030\u00c7\u0001H\u0016J\u0013\u0010\u00c8\u0001\u001a\u00020\u000b2\b\u0010\u00c9\u0001\u001a\u00030\u00ca\u0001H\u0016J\u0013\u0010\u00cb\u0001\u001a\u00020\u000b2\b\u0010\u00cc\u0001\u001a\u00030\u00cd\u0001H\u0016J\u0013\u0010\u00ce\u0001\u001a\u00020\u000b2\b\u0010\u00cf\u0001\u001a\u00030\u00d0\u0001H\u0016J\u0013\u0010\u00d1\u0001\u001a\u00020\u000b2\b\u0010\u00d2\u0001\u001a\u00030\u00d3\u0001H\u0016J\u0013\u0010\u00d4\u0001\u001a\u00020\u000b2\b\u0010\u00d5\u0001\u001a\u00030\u00d6\u0001H\u0016J\u0013\u0010\u00d7\u0001\u001a\u00020\u000b2\b\u0010\u00d8\u0001\u001a\u00030\u00d9\u0001H\u0016J\u0013\u0010\u00da\u0001\u001a\u00020\u000b2\b\u0010\u00db\u0001\u001a\u00030\u00dc\u0001H\u0016J\u0013\u0010\u00dd\u0001\u001a\u00020\u000b2\b\u0010\u00de\u0001\u001a\u00030\u00df\u0001H\u0016J\u0013\u0010\u00e0\u0001\u001a\u00020\u000b2\b\u0010\u00e1\u0001\u001a\u00030\u00e2\u0001H\u0016J\u0013\u0010\u00e3\u0001\u001a\u00020\u000b2\b\u0010\u00e4\u0001\u001a\u00030\u00e5\u0001H\u0016J\u0013\u0010\u00e6\u0001\u001a\u00020\u000b2\b\u0010\u00e7\u0001\u001a\u00030\u00e8\u0001H\u0016J\u0013\u0010\u00e9\u0001\u001a\u00020\u000b2\b\u0010\u00ea\u0001\u001a\u00030\u00eb\u0001H\u0016J\u0013\u0010\u00ec\u0001\u001a\u00020\u000b2\b\u0010\u00ed\u0001\u001a\u00030\u00ee\u0001H\u0016J\u0013\u0010\u00ef\u0001\u001a\u00020\u000b2\b\u0010\u00f0\u0001\u001a\u00030\u00f1\u0001H\u0016J\u0013\u0010\u00f2\u0001\u001a\u00020\u000b2\b\u0010\u00f3\u0001\u001a\u00030\u00f4\u0001H\u0016J*\u0010\u00f5\u0001\u001a\u00020\u000b\"\u000f\b\u0000\u0010<*\t\u0012\u0004\u0012\u0002H<0\u00f6\u00012\u000e\u0010\u00f7\u0001\u001a\t\u0012\u0004\u0012\u0002H<0\u00f6\u0001H\u0016J\u0013\u0010\u00f8\u0001\u001a\u00020\u000b2\b\u0010\u00f9\u0001\u001a\u00030\u00fa\u0001H\u0016J\u0013\u0010\u00fb\u0001\u001a\u00020\u000b2\b\u0010\u00fc\u0001\u001a\u00030\u00fd\u0001H\u0016J\u0013\u0010\u00fe\u0001\u001a\u00020\u000b2\b\u0010\u00ff\u0001\u001a\u00030\u0080\u0002H\u0016J\u0013\u0010\u0081\u0002\u001a\u00020\u000b2\b\u0010\u0082\u0002\u001a\u00030\u0083\u0002H\u0016J\u0013\u0010\u0084\u0002\u001a\u00020\u000b2\b\u0010\u0085\u0002\u001a\u00030\u0086\u0002H\u0016J\u000f\u0010\u0087\u0002\u001a\u00030\u0088\u0002*\u00030\u0089\u0002H\u0002J\u000f\u0010\u008a\u0002\u001a\u00030\u0088\u0002*\u00030\u0093\u0001H\u0002J\u0014\u0010\u008b\u0002\u001a\u00020\u000b*\t\u0012\u0004\u0012\u00020\u001c0\u008c\u0002H\u0002J \u0010\u008d\u0002\u001a\u00020\u000b*\u0002042\u0011\b\u0002\u0010\u008e\u0002\u001a\n\u0012\u0005\u0012\u00030\u00c4\u00010\u008c\u0002H\u0002J\u000e\u0010\u008f\u0002\u001a\u00020\u000b*\u00030\u0090\u0002H\u0002J\u0015\u0010\u0091\u0002\u001a\u00020\u000b*\n\u0012\u0005\u0012\u00030\u00f4\u00010\u008c\u0002H\u0002J\u0014\u0010\u0092\u0002\u001a\u00020\u000b*\t\u0012\u0004\u0012\u00020f0\u008c\u0002H\u0002J\u0015\u0010\u0093\u0002\u001a\u00020\u000b*\n\u0012\u0005\u0012\u00030\u00dc\u00010\u008c\u0002H\u0002J\u000e\u0010\u0094\u0002\u001a\u00020\u000b*\u00030\u0095\u0002H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0096\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/FirRenderer;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;)V", "lineBeginning", "", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "newLine", "", "popIndent", "print", "objects", "", "", "([Ljava/lang/Object;)V", "println", "pushIndent", "renderInBraces", "f", "Lkotlin/Function0;", "renderSupertypes", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "visitAnonymousInitializer", "anonymousInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitArrayOfCall", "arrayOfCall", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayOfCall;", "visitArraySetCall", "arraySetCall", "Lorg/jetbrains/kotlin/fir/expressions/FirArraySetCall;", "visitAssignment", "assignment", "Lorg/jetbrains/kotlin/fir/expressions/FirAssignment;", "visitBackingFieldReference", "backingFieldReference", "Lorg/jetbrains/kotlin/fir/FirBackingFieldReference;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitBreakExpression", "breakExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBreakExpression;", "visitCall", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "visitCallableDeclaration", "F", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "callableDeclaration", "visitCallableReferenceAccess", "callableReferenceAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "visitClassReferenceExpression", "classReferenceExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirClassReferenceExpression;", "visitComponentCall", "componentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;", "visitConstExpression", "T", "constExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitContinueExpression", "continueExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirContinueExpression;", "visitDeclaration", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitDeclarationWithBody", "declarationWithBody", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationWithBody;", "visitDelegatedConstructorCall", "delegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "visitDelegatedTypeRef", "delegatedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirDelegatedTypeRef;", "visitDoWhileLoop", "doWhileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "visitDynamicTypeRef", "dynamicTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirDynamicTypeRef;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitExpression", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "visitFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitFunctionTypeRef", "functionTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitImplicitTypeRef", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "visitImport", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "visitLambdaArgumentExpression", "lambdaArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLambdaArgumentExpression;", "visitLoopJump", "loopJump", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirLoopJump;", "visitMemberDeclaration", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "visitNamedDeclaration", "namedDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedDeclaration;", "visitNamedFunction", "namedFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "visitNamedReference", "namedReference", "Lorg/jetbrains/kotlin/fir/FirNamedReference;", "visitOperatorCall", "operatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirOperatorCall;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitQualifiedAccess", "qualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitRegularClass", "visitResolvedCallableReference", "resolvedCallableReference", "Lorg/jetbrains/kotlin/fir/FirResolvedCallableReference;", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitReturnExpression", "returnExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "visitSpreadArgumentExpression", "spreadArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSpreadArgumentExpression;", "visitStarProjection", "starProjection", "Lorg/jetbrains/kotlin/fir/types/FirStarProjection;", "visitStatement", "statement", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "visitSuperReference", "superReference", "Lorg/jetbrains/kotlin/fir/FirSuperReference;", "visitThisReference", "thisReference", "Lorg/jetbrains/kotlin/fir/FirThisReference;", "visitThrowExpression", "throwExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirThrowExpression;", "visitTryExpression", "tryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "visitTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "visitTypeProjection", "typeProjection", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "visitTypeProjectionWithVariance", "typeProjectionWithVariance", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjectionWithVariance;", "visitTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "visitTypeRefWithNullability", "typeRefWithNullability", "Lorg/jetbrains/kotlin/fir/types/FirTypeRefWithNullability;", "visitTypedDeclaration", "typedDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirTypedDeclaration;", "visitUncheckedNotNullCast", "uncheckedNotNullCast", "Lorg/jetbrains/kotlin/fir/expressions/FirUncheckedNotNullCast;", "visitUserTypeRef", "userTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "visitValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "visitVariable", "Lorg/jetbrains/kotlin/fir/expressions/FirVariable;", "variable", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "visitWhenBranch", "whenBranch", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenBranch;", "visitWhenExpression", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "visitWhenSubjectExpression", "whenSubjectExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenSubjectExpression;", "visitWhileLoop", "whileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "asString", "", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "modalityAsString", "renderAnnotations", "", "renderBody", "additionalStatements", "renderDeclarations", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationContainer;", "renderParameters", "renderSeparated", "renderTypeParameters", "renderVariance", "Lorg/jetbrains/kotlin/types/Variance;", "tree"})
public final class FirRenderer
extends FirVisitorVoid {
    private final Printer printer;
    private boolean lineBeginning;

    private final void print(Object ... objects) {
        if (this.lineBeginning) {
            this.lineBeginning = false;
            this.printer.print(Arrays.copyOf(objects, objects.length));
        } else {
            this.printer.printWithNoIndent(Arrays.copyOf(objects, objects.length));
        }
    }

    private final void println(Object ... objects) {
        this.print(Arrays.copyOf(objects, objects.length));
        this.printer.printlnWithNoIndent(new Object[0]);
        this.lineBeginning = true;
    }

    private final void pushIndent() {
        this.printer.pushIndent();
    }

    private final void popIndent() {
        this.printer.popIndent();
    }

    public final void newLine() {
        this.println(new Object[0]);
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        element.acceptChildren(this);
    }

    @Override
    public void visitFile(@NotNull FirFile file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        this.println("FILE: " + file2.getName());
        this.pushIndent();
        super.visitFile(file2);
        this.popIndent();
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSeparated(@NotNull List<? extends FirElement> $this$renderSeparated) {
        boolean bl = false;
        for (FirElement element : (Iterable)$this$renderSeparated) {
            void index2;
            if (index2 > 0) {
                this.print(", ");
            }
            element.accept(this);
            ++index2;
        }
    }

    private final void renderParameters(@NotNull List<? extends FirValueParameter> $this$renderParameters) {
        this.print("(");
        this.renderSeparated($this$renderParameters);
        this.print(")");
    }

    private final void renderAnnotations(@NotNull List<? extends FirAnnotationCall> $this$renderAnnotations) {
        for (FirAnnotationCall firAnnotationCall : $this$renderAnnotations) {
            this.visitAnnotationCall(firAnnotationCall);
        }
    }

    private final void renderVariance(@NotNull Variance $this$renderVariance) {
        String string = $this$renderVariance.getLabel();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        this.print(it);
        CharSequence charSequence = it;
        boolean bl4 = false;
        if (charSequence.length() > 0) {
            this.print(" ");
        }
    }

    @Override
    public <F extends FirCallableDeclaration<F>> void visitCallableDeclaration(@NotNull FirCallableDeclaration<F> callableDeclaration) {
        Intrinsics.checkParameterIsNotNull(callableDeclaration, "callableDeclaration");
        if (callableDeclaration instanceof FirMemberDeclaration) {
            this.visitMemberDeclaration((FirMemberDeclaration)((Object)callableDeclaration));
        } else {
            this.renderAnnotations(callableDeclaration.getAnnotations());
            this.visitTypedDeclaration(callableDeclaration);
        }
        FirTypeRef receiverType = callableDeclaration.getReceiverTypeRef();
        this.print(" ");
        if (receiverType != null) {
            receiverType.accept(this);
            this.print(".");
        }
        if (callableDeclaration instanceof FirNamedDeclaration) {
            this.print(((FirNamedDeclaration)((Object)callableDeclaration)).getName());
        }
        if (callableDeclaration instanceof FirFunction) {
            this.renderParameters(((FirFunction)((Object)callableDeclaration)).getValueParameters());
        }
        this.print(": ");
        callableDeclaration.getReturnTypeRef().accept(this);
    }

    private final String asString(@NotNull Visibility $this$asString) {
        Visibility visibility = $this$asString;
        return Intrinsics.areEqual(visibility, Visibilities.UNKNOWN) ? "public?" : $this$asString.toString();
    }

    private final String modalityAsString(@NotNull FirMemberDeclaration $this$modalityAsString) {
        Object object;
        block5: {
            boolean bl;
            Object object2;
            block4: {
                object = $this$modalityAsString.getModality();
                if (object == null || (object = object.name()) == null) break block4;
                object2 = object;
                bl = false;
                Object object3 = object2;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)object3).toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull(string, "(this as java.lang.String).toLowerCase()");
                object = string;
                if (string != null) break block5;
            }
            object2 = $this$modalityAsString;
            bl = false;
            boolean bl2 = false;
            Object $this$run = object2;
            boolean bl3 = false;
            object = $this$run instanceof FirCallableMemberDeclaration && ((FirCallableMemberDeclaration)$this$run).isOverride() ? "open?" : "final?";
        }
        return object;
    }

    private final void renderTypeParameters(@NotNull List<? extends FirTypeParameter> $this$renderTypeParameters) {
        Collection collection = $this$renderTypeParameters;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.print("<");
            this.renderSeparated($this$renderTypeParameters);
            this.print(">");
        }
    }

    @Override
    public void visitMemberDeclaration(@NotNull FirMemberDeclaration memberDeclaration) {
        Intrinsics.checkParameterIsNotNull(memberDeclaration, "memberDeclaration");
        this.renderAnnotations(memberDeclaration.getAnnotations());
        this.print(this.asString(memberDeclaration.getVisibility()) + " " + this.modalityAsString(memberDeclaration) + " ");
        if (memberDeclaration.isExpect()) {
            this.print("expect ");
        }
        if (memberDeclaration.isActual()) {
            this.print("actual ");
        }
        if (memberDeclaration instanceof FirCallableMemberDeclaration) {
            if (((FirCallableMemberDeclaration)memberDeclaration).isOverride()) {
                this.print("override ");
            }
            if (((FirCallableMemberDeclaration)memberDeclaration).isStatic()) {
                this.print("static ");
            }
        }
        if (memberDeclaration instanceof FirRegularClass) {
            if (((FirRegularClass)memberDeclaration).isInner()) {
                this.print("inner ");
            }
            if (((FirRegularClass)memberDeclaration).isCompanion()) {
                this.print("companion ");
            }
            if (((FirRegularClass)memberDeclaration).isData()) {
                this.print("data ");
            }
            if (((FirRegularClass)memberDeclaration).isInline()) {
                this.print("inline ");
            }
        } else if (memberDeclaration instanceof FirNamedFunction) {
            if (((FirNamedFunction)memberDeclaration).isOperator()) {
                this.print("operator ");
            }
            if (((FirNamedFunction)memberDeclaration).isInfix()) {
                this.print("infix ");
            }
            if (((FirNamedFunction)memberDeclaration).isInline()) {
                this.print("inline ");
            }
            if (((FirNamedFunction)memberDeclaration).isTailRec()) {
                this.print("tailrec ");
            }
            if (((FirNamedFunction)memberDeclaration).isExternal()) {
                this.print("external ");
            }
            if (((FirNamedFunction)memberDeclaration).isSuspend()) {
                this.print("suspend ");
            }
        } else if (memberDeclaration instanceof FirProperty) {
            if (((FirProperty)memberDeclaration).isConst()) {
                this.print("const ");
            }
            if (((FirProperty)memberDeclaration).isLateInit()) {
                this.print("lateinit ");
            }
        }
        this.visitNamedDeclaration(memberDeclaration);
    }

    @Override
    public void visitNamedDeclaration(@NotNull FirNamedDeclaration namedDeclaration) {
        Intrinsics.checkParameterIsNotNull(namedDeclaration, "namedDeclaration");
        this.visitDeclaration(namedDeclaration);
        if (!(namedDeclaration instanceof FirCallableDeclaration)) {
            this.print(" " + namedDeclaration.getName());
            if (namedDeclaration instanceof FirClassLikeDeclaration) {
                this.renderTypeParameters(((FirClassLikeDeclaration)namedDeclaration).getTypeParameters());
            }
        } else if (namedDeclaration instanceof FirMemberDeclaration) {
            Collection collection = ((FirMemberDeclaration)namedDeclaration).getTypeParameters();
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.print(" ");
                this.renderTypeParameters(((FirMemberDeclaration)namedDeclaration).getTypeParameters());
            }
        }
    }

    @Override
    public void visitDeclaration(@NotNull FirDeclaration declaration2) {
        String string;
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        FirRenderer firRenderer = this;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        int n = 0;
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            String string2 = ((FirRegularClass)declaration2).getClassKind().name();
            int n2 = n;
            Object[] objectArray4 = objectArray2;
            Object[] objectArray5 = objectArray3;
            FirRenderer firRenderer2 = firRenderer;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).toLowerCase()");
            String string5 = string4;
            firRenderer = firRenderer2;
            objectArray3 = objectArray5;
            objectArray2 = objectArray4;
            n = n2;
            string = StringsKt.replace$default(string5, "_", " ", false, 4, null);
        } else {
            string = firDeclaration instanceof FirTypeAlias ? "typealias" : (firDeclaration instanceof FirNamedFunction ? "fun" : (firDeclaration instanceof FirProperty ? (((FirProperty)declaration2).isVal() ? "val" : "var") : (firDeclaration instanceof FirField ? "field" : (firDeclaration instanceof FirVariable ? (((FirVariable)declaration2).isVal() ? "lval" : "lvar") : "unknown"))));
        }
        objectArray2[n] = string;
        firRenderer.print(objectArray3);
    }

    @Override
    public void visitEnumEntry(@NotNull FirEnumEntry enumEntry) {
        Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
        this.visitRegularClass(enumEntry);
    }

    private final void renderDeclarations(@NotNull FirDeclarationContainer $this$renderDeclarations) {
        this.renderInBraces(new Function0<Unit>(this, $this$renderDeclarations){
            final /* synthetic */ FirRenderer this$0;
            final /* synthetic */ FirDeclarationContainer $this_renderDeclarations;

            public final void invoke() {
                for (FirDeclaration declaration2 : this.$this_renderDeclarations.getDeclarations()) {
                    declaration2.accept(this.this$0);
                    FirRenderer.access$println(this.this$0, new Object[0]);
                }
            }
            {
                this.this$0 = firRenderer;
                this.$this_renderDeclarations = firDeclarationContainer;
                super(0);
            }
        });
    }

    public final void renderInBraces(@NotNull Function0<Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, "f");
        this.println(" {");
        this.pushIndent();
        f.invoke();
        this.popIndent();
        this.println("}");
    }

    public final void renderSupertypes(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkParameterIsNotNull(regularClass, "regularClass");
        Collection collection = regularClass.getSuperTypeRefs();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.print(" : ");
            this.renderSeparated(regularClass.getSuperTypeRefs());
        }
    }

    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkParameterIsNotNull(regularClass, "regularClass");
        this.visitMemberDeclaration(regularClass);
        this.renderSupertypes(regularClass);
        this.renderDeclarations(regularClass);
    }

    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject) {
        Intrinsics.checkParameterIsNotNull(anonymousObject, "anonymousObject");
        this.renderAnnotations(anonymousObject.getAnnotations());
        this.print("object : ");
        this.renderSeparated(anonymousObject.getSuperTypeRefs());
        this.renderDeclarations(anonymousObject);
    }

    @Override
    public <F extends FirVariable<F>> void visitVariable(@NotNull FirVariable<F> variable2) {
        block1: {
            FirExpression it;
            boolean bl;
            boolean bl2;
            FirExpression firExpression2;
            Intrinsics.checkParameterIsNotNull(variable2, "variable");
            this.visitCallableDeclaration(variable2);
            FirExpression firExpression3 = variable2.getInitializer();
            if (firExpression3 != null) {
                firExpression2 = firExpression3;
                bl2 = false;
                bl = false;
                it = firExpression2;
                boolean bl3 = false;
                this.print(" = ");
                it.accept(this);
            }
            FirExpression firExpression4 = variable2.getDelegate();
            if (firExpression4 == null) break block1;
            firExpression2 = firExpression4;
            bl2 = false;
            bl = false;
            it = firExpression2;
            boolean bl4 = false;
            this.print("by ");
            it.accept(this);
        }
    }

    @Override
    public void visitField(@NotNull FirField field) {
        Intrinsics.checkParameterIsNotNull(field, "field");
        this.visitVariable(field);
        this.println(new Object[0]);
    }

    @Override
    public void visitProperty(@NotNull FirProperty property) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        this.visitVariable(property);
        this.println(new Object[0]);
        this.pushIndent();
        property.getGetter().accept(this);
        if (property.getGetter().getBody() == null) {
            this.println(new Object[0]);
        }
        if (property.isVar()) {
            FirPropertyAccessor firPropertyAccessor = property.getSetter();
            if (firPropertyAccessor != null) {
                firPropertyAccessor.accept(this);
            }
            FirPropertyAccessor firPropertyAccessor2 = property.getSetter();
            if ((firPropertyAccessor2 != null ? firPropertyAccessor2.getBody() : null) == null) {
                this.println(new Object[0]);
            }
        }
        this.popIndent();
    }

    @Override
    public void visitNamedFunction(@NotNull FirNamedFunction namedFunction) {
        Intrinsics.checkParameterIsNotNull(namedFunction, "namedFunction");
        this.visitCallableDeclaration(namedFunction);
        FirBlock firBlock = namedFunction.getBody();
        if (firBlock != null) {
            FirRenderer.renderBody$default(this, firBlock, null, 1, null);
        }
        if (namedFunction.getBody() == null) {
            this.println(new Object[0]);
        }
    }

    @Override
    public void visitConstructor(@NotNull FirConstructor constructor) {
        block3: {
            Intrinsics.checkParameterIsNotNull(constructor, "constructor");
            this.renderAnnotations(constructor.getAnnotations());
            this.print(this.asString(constructor.getVisibility()) + " constructor");
            this.renderTypeParameters(constructor.getTypeParameters());
            this.renderParameters(constructor.getValueParameters());
            this.print(": ");
            constructor.getReturnTypeRef().accept(this);
            FirBlock body = constructor.getBody();
            FirDelegatedConstructorCall delegatedConstructor = constructor.getDelegatedConstructor();
            if (body == null) {
                if (delegatedConstructor != null) {
                    this.renderInBraces(new Function0<Unit>(this, delegatedConstructor){
                        final /* synthetic */ FirRenderer this$0;
                        final /* synthetic */ FirDelegatedConstructorCall $delegatedConstructor;

                        public final void invoke() {
                            this.$delegatedConstructor.accept(this.this$0);
                            FirRenderer.access$println(this.this$0, new Object[0]);
                        }
                        {
                            this.this$0 = firRenderer;
                            this.$delegatedConstructor = firDelegatedConstructorCall;
                            super(0);
                        }
                    });
                } else {
                    this.println(new Object[0]);
                }
            }
            FirBlock firBlock = body;
            if (firBlock == null) break block3;
            this.renderBody(firBlock, CollectionsKt.listOfNotNull(delegatedConstructor));
        }
    }

    @Override
    public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor) {
        block0: {
            Intrinsics.checkParameterIsNotNull(propertyAccessor, "propertyAccessor");
            this.renderAnnotations(propertyAccessor.getAnnotations());
            this.print(this.asString(propertyAccessor.getVisibility()) + " ");
            this.print(propertyAccessor.isGetter() ? "get" : "set");
            this.renderParameters(propertyAccessor.getValueParameters());
            this.print(": ");
            propertyAccessor.getReturnTypeRef().accept(this);
            FirBlock firBlock = propertyAccessor.getBody();
            if (firBlock == null) break block0;
            FirRenderer.renderBody$default(this, firBlock, null, 1, null);
        }
    }

    @Override
    public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction) {
        block2: {
            Intrinsics.checkParameterIsNotNull(anonymousFunction, "anonymousFunction");
            this.renderAnnotations(anonymousFunction.getAnnotations());
            FirLabel label = anonymousFunction.getLabel();
            if (label != null) {
                this.print(label.getName() + '@');
            }
            this.print("fun ");
            FirTypeRef receiverType = anonymousFunction.getReceiverTypeRef();
            if (receiverType != null) {
                receiverType.accept(this);
                this.print(".");
            }
            this.print("<anonymous>");
            this.renderParameters(anonymousFunction.getValueParameters());
            this.print(": ");
            anonymousFunction.getReturnTypeRef().accept(this);
            FirBlock firBlock = anonymousFunction.getBody();
            if (firBlock == null) break block2;
            FirRenderer.renderBody$default(this, firBlock, null, 1, null);
        }
    }

    @Override
    public void visitFunction(@NotNull FirFunction function2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        this.renderParameters(function2.getValueParameters());
        this.visitDeclarationWithBody(function2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer) {
        block0: {
            Intrinsics.checkParameterIsNotNull(anonymousInitializer, "anonymousInitializer");
            this.print("init");
            FirBlock firBlock = anonymousInitializer.getBody();
            if (firBlock == null) break block0;
            FirRenderer.renderBody$default(this, firBlock, null, 1, null);
        }
    }

    @Override
    public void visitDeclarationWithBody(@NotNull FirDeclarationWithBody declarationWithBody) {
        block0: {
            Intrinsics.checkParameterIsNotNull(declarationWithBody, "declarationWithBody");
            this.visitDeclaration(declarationWithBody);
            FirBlock firBlock = declarationWithBody.getBody();
            if (firBlock == null) break block0;
            FirRenderer.renderBody$default(this, firBlock, null, 1, null);
        }
    }

    private final void renderBody(@NotNull FirBlock $this$renderBody, List<? extends FirStatement> additionalStatements2) {
        this.renderInBraces(new Function0<Unit>(this, $this$renderBody, additionalStatements2){
            final /* synthetic */ FirRenderer this$0;
            final /* synthetic */ FirBlock $this_renderBody;
            final /* synthetic */ List $additionalStatements;

            public final void invoke() {
                for (FirStatement statement2 : CollectionsKt.plus((Collection)this.$additionalStatements, (Iterable)this.$this_renderBody.getStatements())) {
                    statement2.accept(this.this$0);
                    FirRenderer.access$println(this.this$0, new Object[0]);
                }
            }
            {
                this.this$0 = firRenderer;
                this.$this_renderBody = firBlock;
                this.$additionalStatements = list2;
                super(0);
            }
        });
    }

    static /* synthetic */ void renderBody$default(FirRenderer firRenderer, FirBlock firBlock, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        firRenderer.renderBody(firBlock, list2);
    }

    @Override
    public void visitBlock(@NotNull FirBlock block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        FirRenderer.renderBody$default(this, block, null, 1, null);
    }

    @Override
    public void visitTypeAlias(@NotNull FirTypeAlias typeAlias) {
        Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
        this.renderAnnotations(typeAlias.getAnnotations());
        this.visitMemberDeclaration(typeAlias);
        this.print(" = ");
        typeAlias.getExpandedTypeRef().accept(this);
        this.println(new Object[0]);
    }

    @Override
    public void visitTypeParameter(@NotNull FirTypeParameter typeParameter) {
        Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
        this.renderAnnotations(typeParameter.getAnnotations());
        if (typeParameter.isReified()) {
            this.print("reified ");
        }
        this.renderVariance(typeParameter.getVariance());
        this.print(typeParameter.getName());
        Collection collection = typeParameter.getBounds();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.print(" : ");
            this.renderSeparated(typeParameter.getBounds());
        }
    }

    @Override
    public void visitTypedDeclaration(@NotNull FirTypedDeclaration typedDeclaration) {
        Intrinsics.checkParameterIsNotNull(typedDeclaration, "typedDeclaration");
        this.visitDeclaration(typedDeclaration);
    }

    @Override
    public void visitValueParameter(@NotNull FirValueParameter valueParameter) {
        block4: {
            Intrinsics.checkParameterIsNotNull(valueParameter, "valueParameter");
            this.renderAnnotations(valueParameter.getAnnotations());
            if (valueParameter.isCrossinline()) {
                this.print("crossinline ");
            }
            if (valueParameter.isNoinline()) {
                this.print("noinline ");
            }
            if (valueParameter.isVararg()) {
                this.print("vararg ");
            }
            if (Intrinsics.areEqual(valueParameter.getName(), SpecialNames.NO_NAME_PROVIDED) ^ true) {
                this.print(valueParameter.getName().toString() + ": ");
            }
            valueParameter.getReturnTypeRef().accept(this);
            FirExpression firExpression2 = valueParameter.getDefaultValue();
            if (firExpression2 == null) break block4;
            FirExpression firExpression3 = firExpression2;
            boolean bl = false;
            boolean bl2 = false;
            FirExpression it = firExpression3;
            boolean bl3 = false;
            this.print(" = ");
            it.accept(this);
        }
    }

    @Override
    public void visitImport(@NotNull FirImport firImport) {
        Intrinsics.checkParameterIsNotNull(firImport, "import");
        this.visitElement(firImport);
    }

    @Override
    public void visitStatement(@NotNull FirStatement statement2) {
        Intrinsics.checkParameterIsNotNull(statement2, "statement");
        this.visitElement(statement2);
    }

    @Override
    public void visitReturnExpression(@NotNull FirReturnExpression returnExpression) {
        Intrinsics.checkParameterIsNotNull(returnExpression, "returnExpression");
        this.renderAnnotations(returnExpression.getAnnotations());
        this.print("^");
        FirTarget target = returnExpression.getTarget();
        FirFunction labeledElement = (FirFunction)target.getLabeledElement();
        if (labeledElement instanceof FirNamedFunction) {
            this.print(String.valueOf(((FirNamedFunction)labeledElement).getName()));
        } else {
            String labelName = target.getLabelName();
            if (labelName != null) {
                this.print('@' + labelName);
            }
        }
        this.print(" ");
        returnExpression.getResult().accept(this);
    }

    @Override
    public void visitWhenBranch(@NotNull FirWhenBranch whenBranch) {
        Intrinsics.checkParameterIsNotNull(whenBranch, "whenBranch");
        FirExpression condition = whenBranch.getCondition();
        if (condition instanceof FirElseIfTrueCondition) {
            this.print("else");
        } else {
            condition.accept(this);
        }
        this.print(" -> ");
        whenBranch.getResult().accept(this);
    }

    @Override
    public void visitWhenExpression(@NotNull FirWhenExpression whenExpression) {
        Intrinsics.checkParameterIsNotNull(whenExpression, "whenExpression");
        this.renderAnnotations(whenExpression.getAnnotations());
        this.print("when (");
        FirVariable<?> subjectVariable = whenExpression.getSubjectVariable();
        if (subjectVariable != null) {
            subjectVariable.accept(this);
        } else {
            FirExpression firExpression2 = whenExpression.getSubject();
            if (firExpression2 != null) {
                firExpression2.accept(this);
            }
        }
        this.println(") {");
        this.pushIndent();
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.accept(this);
        }
        this.popIndent();
        this.println("}");
    }

    @Override
    public void visitWhenSubjectExpression(@NotNull FirWhenSubjectExpression whenSubjectExpression) {
        Intrinsics.checkParameterIsNotNull(whenSubjectExpression, "whenSubjectExpression");
        this.print("$subj$");
    }

    @Override
    public void visitTryExpression(@NotNull FirTryExpression tryExpression) {
        Intrinsics.checkParameterIsNotNull(tryExpression, "tryExpression");
        this.renderAnnotations(tryExpression.getAnnotations());
        this.print("try");
        tryExpression.getTryBlock().accept(this);
        for (FirCatch catchClause : tryExpression.getCatches()) {
            this.print("catch (");
            catchClause.getParameter().accept(this);
            this.print(")");
            catchClause.getBlock().accept(this);
        }
        FirBlock firBlock = tryExpression.getFinallyBlock();
        if (firBlock == null) {
            return;
        }
        FirBlock finallyBlock = firBlock;
        this.print("finally");
        finallyBlock.accept(this);
    }

    @Override
    public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop) {
        Intrinsics.checkParameterIsNotNull(doWhileLoop, "doWhileLoop");
        FirLabel label = doWhileLoop.getLabel();
        if (label != null) {
            this.print(label.getName() + '@');
        }
        this.print("do");
        doWhileLoop.getBlock().accept(this);
        this.print("while(");
        doWhileLoop.getCondition().accept(this);
        this.print(")");
    }

    @Override
    public void visitWhileLoop(@NotNull FirWhileLoop whileLoop) {
        Intrinsics.checkParameterIsNotNull(whileLoop, "whileLoop");
        FirLabel label = whileLoop.getLabel();
        if (label != null) {
            this.print(label.getName() + '@');
        }
        this.print("while(");
        whileLoop.getCondition().accept(this);
        this.print(")");
        whileLoop.getBlock().accept(this);
    }

    @Override
    public void visitLoopJump(@NotNull FirLoopJump loopJump) {
        Intrinsics.checkParameterIsNotNull(loopJump, "loopJump");
        FirTarget<FirLoop> target = loopJump.getTarget();
        FirLoop labeledElement = target.getLabeledElement();
        this.print("@@@[");
        labeledElement.getCondition().accept(this);
        this.print("] ");
    }

    @Override
    public void visitBreakExpression(@NotNull FirBreakExpression breakExpression) {
        Intrinsics.checkParameterIsNotNull(breakExpression, "breakExpression");
        this.renderAnnotations(breakExpression.getAnnotations());
        this.print("break");
        this.visitLoopJump(breakExpression);
    }

    @Override
    public void visitContinueExpression(@NotNull FirContinueExpression continueExpression) {
        Intrinsics.checkParameterIsNotNull(continueExpression, "continueExpression");
        this.renderAnnotations(continueExpression.getAnnotations());
        this.print("continue");
        this.visitLoopJump(continueExpression);
    }

    @Override
    public void visitExpression(@NotNull FirExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        this.renderAnnotations(expression2.getAnnotations());
        Object[] objectArray = new Object[1];
        FirExpression firExpression2 = expression2;
        objectArray[0] = firExpression2 instanceof FirExpressionStub ? "STUB" : (firExpression2 instanceof FirUnitExpression ? "Unit" : (firExpression2 instanceof FirElseIfTrueCondition ? "else" : "??? " + expression2.getClass()));
        this.print(objectArray);
    }

    @Override
    public <T> void visitConstExpression(@NotNull FirConstExpression<T> constExpression) {
        Intrinsics.checkParameterIsNotNull(constExpression, "constExpression");
        this.renderAnnotations(constExpression.getAnnotations());
        this.print("" + constExpression.getKind() + '(' + constExpression.getValue() + ')');
    }

    @Override
    public void visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression) {
        Intrinsics.checkParameterIsNotNull(namedArgumentExpression, "namedArgumentExpression");
        this.print(namedArgumentExpression.getName());
        this.print(" = ");
        if (namedArgumentExpression.isSpread()) {
            this.print("*");
        }
        namedArgumentExpression.getExpression().accept(this);
    }

    @Override
    public void visitSpreadArgumentExpression(@NotNull FirSpreadArgumentExpression spreadArgumentExpression) {
        Intrinsics.checkParameterIsNotNull(spreadArgumentExpression, "spreadArgumentExpression");
        if (spreadArgumentExpression.isSpread()) {
            this.print("*");
        }
        spreadArgumentExpression.getExpression().accept(this);
    }

    @Override
    public void visitLambdaArgumentExpression(@NotNull FirLambdaArgumentExpression lambdaArgumentExpression) {
        Intrinsics.checkParameterIsNotNull(lambdaArgumentExpression, "lambdaArgumentExpression");
        this.print("<L> = ");
        lambdaArgumentExpression.getExpression().accept(this);
    }

    @Override
    public void visitCall(@NotNull FirCall call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        this.print("(");
        this.renderSeparated(call2.getArguments());
        this.print(")");
    }

    @Override
    public void visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall) {
        Intrinsics.checkParameterIsNotNull(stringConcatenationCall, "stringConcatenationCall");
        this.print("<strcat>");
        this.visitCall(stringConcatenationCall);
    }

    @Override
    public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall) {
        Intrinsics.checkParameterIsNotNull(typeOperatorCall, "typeOperatorCall");
        this.print("(");
        typeOperatorCall.getArgument().accept(this);
        this.print(" ");
        this.print(typeOperatorCall.getOperation().getOperator());
        this.print(" ");
        typeOperatorCall.getConversionTypeRef().accept(this);
        this.print(")");
    }

    @Override
    public void visitAnnotationCall(@NotNull FirAnnotationCall annotationCall) {
        Intrinsics.checkParameterIsNotNull(annotationCall, "annotationCall");
        this.print("@");
        AnnotationUseSiteTarget annotationUseSiteTarget = annotationCall.getUseSiteTarget();
        if (annotationUseSiteTarget != null) {
            AnnotationUseSiteTarget annotationUseSiteTarget2 = annotationUseSiteTarget;
            boolean bl = false;
            boolean bl2 = false;
            AnnotationUseSiteTarget it = annotationUseSiteTarget2;
            boolean bl3 = false;
            this.print(it.name());
            this.print(":");
        }
        annotationCall.getAnnotationTypeRef().accept(this);
        this.visitCall(annotationCall);
        if (annotationCall.getUseSiteTarget() == AnnotationUseSiteTarget.FILE) {
            this.println(new Object[0]);
        } else {
            this.print(" ");
        }
    }

    @Override
    public void visitDelegatedConstructorCall(@NotNull FirDelegatedConstructorCall delegatedConstructorCall) {
        Intrinsics.checkParameterIsNotNull(delegatedConstructorCall, "delegatedConstructorCall");
        if (delegatedConstructorCall.isSuper()) {
            this.print("super<");
        } else if (delegatedConstructorCall.isThis()) {
            this.print("this<");
        }
        delegatedConstructorCall.getConstructedTypeRef().accept(this);
        this.print(">");
        this.visitCall(delegatedConstructorCall);
    }

    @Override
    public void visitTypeRef(@NotNull FirTypeRef typeRef) {
        Intrinsics.checkParameterIsNotNull(typeRef, "typeRef");
        this.renderAnnotations(typeRef.getAnnotations());
        this.visitElement(typeRef);
    }

    @Override
    public void visitDelegatedTypeRef(@NotNull FirDelegatedTypeRef delegatedTypeRef) {
        block0: {
            Intrinsics.checkParameterIsNotNull(delegatedTypeRef, "delegatedTypeRef");
            delegatedTypeRef.getTypeRef().accept(this);
            this.print(" by ");
            FirExpression firExpression2 = delegatedTypeRef.getDelegate();
            if (firExpression2 == null) break block0;
            firExpression2.accept(this);
        }
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef) {
        Intrinsics.checkParameterIsNotNull(errorTypeRef, "errorTypeRef");
        this.visitTypeRef(errorTypeRef);
        this.print("<ERROR TYPE REF: " + errorTypeRef.getReason() + '>');
    }

    @Override
    public void visitImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef) {
        Intrinsics.checkParameterIsNotNull(implicitTypeRef, "implicitTypeRef");
        this.print("<implicit>");
    }

    @Override
    public void visitTypeRefWithNullability(@NotNull FirTypeRefWithNullability typeRefWithNullability) {
        Intrinsics.checkParameterIsNotNull(typeRefWithNullability, "typeRefWithNullability");
        if (typeRefWithNullability.isMarkedNullable()) {
            this.print("?");
        }
    }

    @Override
    public void visitDynamicTypeRef(@NotNull FirDynamicTypeRef dynamicTypeRef) {
        Intrinsics.checkParameterIsNotNull(dynamicTypeRef, "dynamicTypeRef");
        this.renderAnnotations(dynamicTypeRef.getAnnotations());
        this.print("<dynamic>");
        this.visitTypeRefWithNullability(dynamicTypeRef);
    }

    @Override
    public void visitFunctionTypeRef(@NotNull FirFunctionTypeRef functionTypeRef) {
        Intrinsics.checkParameterIsNotNull(functionTypeRef, "functionTypeRef");
        this.print("( ");
        FirTypeRef firTypeRef = functionTypeRef.getReceiverTypeRef();
        if (firTypeRef != null) {
            FirTypeRef firTypeRef2 = firTypeRef;
            boolean bl = false;
            boolean bl2 = false;
            FirTypeRef it = firTypeRef2;
            boolean bl3 = false;
            it.accept(this);
            this.print(".");
        }
        this.renderParameters(functionTypeRef.getValueParameters());
        this.print(" -> ");
        functionTypeRef.getReturnTypeRef().accept(this);
        this.print(" )");
        this.visitTypeRefWithNullability(functionTypeRef);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef) {
        Intrinsics.checkParameterIsNotNull(resolvedTypeRef, "resolvedTypeRef");
        this.renderAnnotations(resolvedTypeRef.getAnnotations());
        if (!(resolvedTypeRef instanceof FirImplicitBuiltinTypeRef)) {
            this.print("R|");
        }
        ConeKotlinType coneType = resolvedTypeRef.getType();
        this.print(FirRendererKt.render(coneType));
        if (!(resolvedTypeRef instanceof FirImplicitBuiltinTypeRef)) {
            this.print("|");
        }
        if (!(coneType instanceof ConeClassErrorType) && !(coneType instanceof ConeClassErrorType)) {
            this.print(coneType.getNullability().getSuffix());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitUserTypeRef(@NotNull FirUserTypeRef userTypeRef) {
        Intrinsics.checkParameterIsNotNull(userTypeRef, "userTypeRef");
        this.renderAnnotations(userTypeRef.getAnnotations());
        boolean bl = false;
        for (FirQualifierPart qualifier : (Iterable)userTypeRef.getQualifier()) {
            void index2;
            if (index2 != false) {
                this.print(".");
            }
            this.print(qualifier.getName());
            Collection collection = qualifier.getTypeArguments();
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                this.print("<");
                this.renderSeparated(qualifier.getTypeArguments());
                this.print(">");
            }
            ++index2;
        }
        this.visitTypeRefWithNullability(userTypeRef);
    }

    @Override
    public void visitTypeProjection(@NotNull FirTypeProjection typeProjection) {
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        this.visitElement(typeProjection);
    }

    @Override
    public void visitTypeProjectionWithVariance(@NotNull FirTypeProjectionWithVariance typeProjectionWithVariance) {
        Intrinsics.checkParameterIsNotNull(typeProjectionWithVariance, "typeProjectionWithVariance");
        this.renderVariance(typeProjectionWithVariance.getVariance());
        typeProjectionWithVariance.getTypeRef().accept(this);
    }

    @Override
    public void visitStarProjection(@NotNull FirStarProjection starProjection) {
        Intrinsics.checkParameterIsNotNull(starProjection, "starProjection");
        this.print("*");
    }

    @Override
    public void visitNamedReference(@NotNull FirNamedReference namedReference) {
        Intrinsics.checkParameterIsNotNull(namedReference, "namedReference");
        if (namedReference instanceof FirErrorNamedReference) {
            this.print('<' + ((FirErrorNamedReference)namedReference).getErrorReason() + ">#");
        } else {
            this.print("" + namedReference.getName() + '#');
        }
    }

    @Override
    public void visitBackingFieldReference(@NotNull FirBackingFieldReference backingFieldReference) {
        Intrinsics.checkParameterIsNotNull(backingFieldReference, "backingFieldReference");
        this.print("F|");
        this.print(backingFieldReference.getConeSymbol().getCallableId());
        this.print("|");
    }

    @Override
    public void visitResolvedCallableReference(@NotNull FirResolvedCallableReference resolvedCallableReference) {
        ConeSymbol symbol2;
        boolean isFakeOverride;
        Intrinsics.checkParameterIsNotNull(resolvedCallableReference, "resolvedCallableReference");
        this.print("R|");
        ConeSymbol coneSymbol = resolvedCallableReference.getConeSymbol();
        if (!(coneSymbol instanceof FirNamedFunctionSymbol)) {
            coneSymbol = null;
        }
        FirNamedFunctionSymbol firNamedFunctionSymbol = (FirNamedFunctionSymbol)coneSymbol;
        boolean bl = isFakeOverride = firNamedFunctionSymbol != null && firNamedFunctionSymbol.isFakeOverride();
        if (isFakeOverride) {
            this.print("FakeOverride<");
        }
        if ((symbol2 = resolvedCallableReference.getConeSymbol()) instanceof ConeCallableSymbol) {
            this.print(((ConeCallableSymbol)symbol2).getCallableId());
        } else if (symbol2 instanceof ConeClassLikeSymbol) {
            this.print(((ConeClassLikeSymbol)symbol2).getClassId());
        }
        if (isFakeOverride) {
            ConeSymbol coneSymbol2 = symbol2;
            if (coneSymbol2 instanceof FirNamedFunctionSymbol) {
                this.print(": ");
                ((FirNamedFunction)((FirNamedFunctionSymbol)symbol2).getFir()).getReturnTypeRef().accept(this);
            } else if (coneSymbol2 instanceof FirPropertySymbol) {
                this.print(": ");
                ((FirProperty)((FirPropertySymbol)symbol2).getFir()).getReturnTypeRef().accept(this);
            }
            this.print(">");
        }
        this.print("|");
    }

    @Override
    public void visitThisReference(@NotNull FirThisReference thisReference) {
        Intrinsics.checkParameterIsNotNull(thisReference, "thisReference");
        this.print("this");
        String labelName = thisReference.getLabelName();
        if (labelName != null) {
            this.print('@' + labelName);
        } else {
            this.print("#");
        }
    }

    @Override
    public void visitSuperReference(@NotNull FirSuperReference superReference) {
        Intrinsics.checkParameterIsNotNull(superReference, "superReference");
        this.print("super<");
        superReference.getSuperTypeRef().accept(this);
        this.print(">");
    }

    @Override
    public void visitQualifiedAccess(@NotNull FirQualifiedAccess qualifiedAccess) {
        Intrinsics.checkParameterIsNotNull(qualifiedAccess, "qualifiedAccess");
        FirExpression explicitReceiver = qualifiedAccess.getExplicitReceiver();
        if (explicitReceiver != null) {
            explicitReceiver.accept(this);
            if (qualifiedAccess.getSafe()) {
                this.print("?.");
            } else {
                this.print(".");
            }
        }
    }

    @Override
    public void visitCallableReferenceAccess(@NotNull FirCallableReferenceAccess callableReferenceAccess) {
        Intrinsics.checkParameterIsNotNull(callableReferenceAccess, "callableReferenceAccess");
        this.renderAnnotations(callableReferenceAccess.getAnnotations());
        FirExpression firExpression2 = callableReferenceAccess.getExplicitReceiver();
        if (firExpression2 != null) {
            firExpression2.accept(this);
        }
        this.print("::");
        callableReferenceAccess.getCalleeReference().accept(this);
    }

    @Override
    public void visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression) {
        Intrinsics.checkParameterIsNotNull(qualifiedAccessExpression, "qualifiedAccessExpression");
        this.renderAnnotations(qualifiedAccessExpression.getAnnotations());
        this.visitQualifiedAccess(qualifiedAccessExpression);
        qualifiedAccessExpression.getCalleeReference().accept(this);
    }

    @Override
    public void visitAssignment(@NotNull FirAssignment assignment) {
        Intrinsics.checkParameterIsNotNull(assignment, "assignment");
        this.print(assignment.getOperation().getOperator());
        this.print(" ");
        assignment.getRValue().accept(this);
    }

    @Override
    public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment) {
        Intrinsics.checkParameterIsNotNull(variableAssignment, "variableAssignment");
        this.renderAnnotations(variableAssignment.getAnnotations());
        this.visitQualifiedAccess(variableAssignment);
        variableAssignment.getLValue().accept(this);
        this.print(" ");
        this.visitAssignment(variableAssignment);
    }

    @Override
    public void visitArraySetCall(@NotNull FirArraySetCall arraySetCall) {
        Intrinsics.checkParameterIsNotNull(arraySetCall, "arraySetCall");
        this.renderAnnotations(arraySetCall.getAnnotations());
        this.visitQualifiedAccess(arraySetCall);
        arraySetCall.getLValue().accept(this);
        this.print("[");
        this.renderSeparated(arraySetCall.getIndexes());
        this.print("] ");
        this.visitAssignment(arraySetCall);
    }

    @Override
    public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
        Intrinsics.checkParameterIsNotNull(functionCall, "functionCall");
        this.renderAnnotations(functionCall.getAnnotations());
        this.visitQualifiedAccess(functionCall);
        functionCall.getCalleeReference().accept(this);
        Collection collection = functionCall.getTypeArguments();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.print("<");
            this.renderSeparated(functionCall.getTypeArguments());
            this.print(">");
        }
        this.visitCall(functionCall);
    }

    @Override
    public void visitOperatorCall(@NotNull FirOperatorCall operatorCall) {
        Intrinsics.checkParameterIsNotNull(operatorCall, "operatorCall");
        this.renderAnnotations(operatorCall.getAnnotations());
        this.print(operatorCall.getOperation().getOperator());
        if (operatorCall instanceof FirTypeOperatorCall) {
            this.print("/");
            ((FirTypeOperatorCall)operatorCall).getConversionTypeRef().accept(this);
        }
        this.visitCall(operatorCall);
    }

    @Override
    public void visitComponentCall(@NotNull FirComponentCall componentCall) {
        Intrinsics.checkParameterIsNotNull(componentCall, "componentCall");
        this.renderAnnotations(componentCall.getAnnotations());
        componentCall.getExplicitReceiver().accept(this);
        this.print(".component" + componentCall.getComponentIndex() + "()");
    }

    @Override
    public void visitGetClassCall(@NotNull FirGetClassCall getClassCall) {
        Intrinsics.checkParameterIsNotNull(getClassCall, "getClassCall");
        this.renderAnnotations(getClassCall.getAnnotations());
        this.print("<getClass>");
        this.visitCall(getClassCall);
    }

    @Override
    public void visitClassReferenceExpression(@NotNull FirClassReferenceExpression classReferenceExpression) {
        Intrinsics.checkParameterIsNotNull(classReferenceExpression, "classReferenceExpression");
        this.renderAnnotations(classReferenceExpression.getAnnotations());
        this.print("<getClass>");
        this.print("(");
        classReferenceExpression.getClassTypeRef().accept(this);
        this.print(")");
    }

    @Override
    public void visitArrayOfCall(@NotNull FirArrayOfCall arrayOfCall) {
        Intrinsics.checkParameterIsNotNull(arrayOfCall, "arrayOfCall");
        this.renderAnnotations(arrayOfCall.getAnnotations());
        this.print("<implicitArrayOf>");
        this.visitCall(arrayOfCall);
    }

    @Override
    public void visitThrowExpression(@NotNull FirThrowExpression throwExpression) {
        Intrinsics.checkParameterIsNotNull(throwExpression, "throwExpression");
        this.renderAnnotations(throwExpression.getAnnotations());
        this.print("throw ");
        throwExpression.getException().accept(this);
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression) {
        Intrinsics.checkParameterIsNotNull(errorExpression, "errorExpression");
        this.print("ERROR_EXPR(" + errorExpression.getReason() + ')');
    }

    @Override
    public void visitUncheckedNotNullCast(@NotNull FirUncheckedNotNullCast uncheckedNotNullCast) {
        Intrinsics.checkParameterIsNotNull(uncheckedNotNullCast, "uncheckedNotNullCast");
        uncheckedNotNullCast.getExpression().accept(this);
        this.print("!");
    }

    @Override
    public void visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier) {
        Intrinsics.checkParameterIsNotNull(resolvedQualifier, "resolvedQualifier");
        this.print("Q|");
        ClassId classId = resolvedQualifier.getClassId();
        if (classId != null) {
            Object[] objectArray = new Object[1];
            String string = classId.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "classId.asString()");
            objectArray[0] = string;
            this.print(objectArray);
        } else {
            Object[] objectArray = new Object[1];
            String string = resolvedQualifier.getPackageFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resolvedQualifier.packageFqName.asString()");
            objectArray[0] = StringsKt.replace$default(string, ".", "/", false, 4, null);
            this.print(objectArray);
        }
        this.print("|");
    }

    public FirRenderer(@NotNull StringBuilder builder) {
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        this.printer = new Printer(builder);
        this.lineBeginning = true;
    }

    public static final /* synthetic */ void access$println(FirRenderer $this, Object ... objects) {
        $this.println(objects);
    }
}

