/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.io.Page;
import com.intellij.util.io.PagePool;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class RandomAccessDataFile
implements Closeable {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.RandomAccessDataFile");
    private static final OpenChannelsCache ourCache = new OpenChannelsCache(150, "rw");
    private final int myCount;
    private final File myFile;
    private final PagePool myPool;
    private long lastSeek;
    private volatile long mySize;
    private volatile boolean myIsDirty;
    private volatile boolean myIsDisposed;
    public static int totalReads;
    public static long totalReadBytes;
    public static int totalWrites;
    public static long totalWriteBytes;

    private void releaseFile() {
        ourCache.releaseChannel(this.myFile);
    }

    private RandomAccessFile getRandomAccessFile() throws FileNotFoundException {
        return ourCache.getChannel(this.myFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long physicalLength() {
        long res2;
        this.assertNotDisposed();
        try {
            RandomAccessFile file2 = this.getRandomAccessFile();
            try {
                RandomAccessFile randomAccessFile = file2;
                synchronized (randomAccessFile) {
                    res2 = file2.length();
                }
            }
            finally {
                this.releaseFile();
            }
        }
        catch (IOException e) {
            return 0L;
        }
        return res2;
    }

    public void dispose() {
        if (this.myIsDisposed) {
            return;
        }
        this.myPool.flushPages(this);
        ourCache.closeChannel(this.myFile);
        this.myIsDisposed = true;
    }

    @Override
    public void close() {
        this.dispose();
    }

    private void assertNotDisposed() {
        if (this.myIsDisposed) {
            LOG.error("storage file is disposed: " + this.myFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadPage(Page page) {
        this.assertNotDisposed();
        try {
            RandomAccessFile file2 = this.getRandomAccessFile();
            try {
                RandomAccessFile randomAccessFile = file2;
                synchronized (randomAccessFile) {
                    this.seek(file2, page.getOffset());
                    ByteBuffer buf = page.getBuf();
                    ++totalReads;
                    totalReadBytes += (long)Page.PAGE_SIZE;
                    file2.read(buf.array(), 0, Page.PAGE_SIZE);
                    this.lastSeek += (long)Page.PAGE_SIZE;
                }
            }
            finally {
                this.releaseFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void flushPage(Page page, int start, int end) {
        this.assertNotDisposed();
        try {
            this.flush(page.getBuf(), page.getOffset() + (long)start, start, end - start);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(ByteBuffer buf, long fileOffset, int bufOffset, int length) throws IOException {
        if (fileOffset + (long)length > this.mySize) {
            length = (int)(this.mySize - fileOffset);
        }
        RandomAccessFile file2 = this.getRandomAccessFile();
        try {
            RandomAccessFile randomAccessFile = file2;
            synchronized (randomAccessFile) {
                this.seek(file2, fileOffset);
                ++totalWrites;
                totalWriteBytes += (long)length;
                file2.write(buf.array(), bufOffset, length);
                this.lastSeek += (long)length;
            }
        }
        finally {
            this.releaseFile();
        }
    }

    private void seek(RandomAccessFile file2, long fileOffset) throws IOException {
        file2.seek(fileOffset);
    }

    public int hashCode() {
        return this.myCount;
    }

    public synchronized String toString() {
        return "RandomAccessFile[" + this.myFile + ", dirty=" + this.myIsDirty + "]";
    }
}

