/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;

public class LambdaExpressionCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance(LambdaExpressionCompatibilityConstraint.class);
    private final PsiLambdaExpression myExpression;
    private PsiType myT;

    public LambdaExpressionCompatibilityConstraint(PsiLambdaExpression expression2, PsiType t) {
        this.myExpression = expression2;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        block17: {
            if (!LambdaUtil.isFunctionalType(this.myT)) {
                session.registerIncompatibleErrorMessage(session.getPresentableText(this.myT) + " is not a functional interface");
                return false;
            }
            PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, this.myExpression, false);
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                session.registerIncompatibleErrorMessage("No valid function type can be found for " + session.getPresentableText(this.myT));
                return false;
            }
            PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
            PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
            PsiParameter[] lambdaParameters = this.myExpression.getParameterList().getParameters();
            if (lambdaParameters.length != parameters2.length) {
                session.registerIncompatibleErrorMessage("Incompatible parameter types in lambda expression");
                return false;
            }
            if (this.myExpression.hasFormalParameterTypes()) {
                for (int i = 0; i < lambdaParameters.length; ++i) {
                    constraints.add(new TypeEqualityConstraint(lambdaParameters[i].getType(), session.substituteWithInferenceVariables(substitutor2.substitute(parameters2[i].getType()))));
                }
                constraints.add(new StrictSubtypingConstraint(this.myT, groundTargetType));
            } else {
                for (PsiParameter parameter : parameters2) {
                    PsiType type3 = session.substituteWithInferenceVariables(substitutor2.substitute(parameter.getType()));
                    if (session.isProperType(type3)) continue;
                    return false;
                }
            }
            PsiType returnType2 = interfaceMethod.getReturnType();
            if (returnType2 == null) break block17;
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(this.myExpression);
            PsiElement lambdaBody = this.myExpression.getBody();
            if (returnType2.equals(PsiType.VOID)) {
                if (!(lambdaBody instanceof PsiCodeBlock && this.myExpression.isVoidCompatible() || LambdaUtil.isExpressionStatementExpression(lambdaBody))) {
                    session.registerIncompatibleErrorMessage("Incompatible types: expected void but the lambda body is neither a statement expression nor a void-compatible block");
                    return false;
                }
            } else {
                if (lambdaBody instanceof PsiCodeBlock && !this.myExpression.isValueCompatible()) {
                    session.registerIncompatibleErrorMessage("Incompatible types: expected not void but the lambda body is a block that is not value-compatible");
                    return false;
                }
                PsiSubstitutor nestedSubstitutor = session.getInferenceSessionContainer().findNestedSubstitutor(this.myExpression, session.getInferenceSubstitution());
                returnType2 = nestedSubstitutor.substitute(substitutor2.substitute(returnType2));
                boolean isProperType2 = InferenceSession.collectDependencies(returnType2, null, type2 -> {
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
                    return psiClass instanceof InferenceVariable && nestedSubstitutor.getSubstitutionMap().containsValue(type2) ? (InferenceVariable)psiClass : null;
                });
                if (!isProperType2 || this.myExpression.hasFormalParameterTypes()) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        constraints.add(new ExpressionCompatibilityConstraint(returnExpression, returnType2));
                    }
                } else {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (PsiPolyExpressionUtil.isPolyExpression(returnExpression) || TypeConversionUtil.areTypesAssignmentCompatible(returnType2, returnExpression)) continue;
                        PsiType type4 = returnExpression.getType();
                        if (type4 != null) {
                            session.registerIncompatibleErrorMessage("Bad return type in lambda expression: " + session.getPresentableText(type4) + " cannot be converted to " + session.getPresentableText(returnType2));
                        } else {
                            session.registerIncompatibleErrorMessage(returnExpression.getText() + " is not compatible with " + session.getPresentableText(returnType2));
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

