/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LightMemberReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    @NotNull
    private final PsiMember myRefMember;
    private final PsiSubstitutor mySubstitutor;
    private LightReferenceParameterList myParameterList;

    public LightMemberReference(@NotNull PsiManager manager, @NotNull PsiMember member, PsiSubstitutor substitutor2) {
        if (manager == null) {
            LightMemberReference.$$$reportNull$$$0(0);
        }
        if (member == null) {
            LightMemberReference.$$$reportNull$$$0(1);
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myRefMember = member;
        this.mySubstitutor = substitutor2;
    }

    @Override
    @NotNull
    public PsiElement resolve() {
        PsiMember psiMember = this.myRefMember;
        if (psiMember == null) {
            LightMemberReference.$$$reportNull$$$0(2);
        }
        return psiMember;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolved = this.resolve();
        PsiSubstitutor substitutor2 = this.mySubstitutor;
        if (substitutor2 == null) {
            substitutor2 = PsiSubstitutor.EMPTY;
        }
        CandidateInfo candidateInfo = new CandidateInfo(resolved, substitutor2);
        if (candidateInfo == null) {
            LightMemberReference.$$$reportNull$$$0(3);
        }
        return candidateInfo;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult result2 = this.advancedResolve(incompleteCode);
        if (result2 != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{result2};
            if (javaResolveResultArray == null) {
                LightMemberReference.$$$reportNull$$$0(4);
            }
            return javaResolveResultArray;
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            LightMemberReference.$$$reportNull$$$0(5);
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        if (processor2 == null) {
            LightMemberReference.$$$reportNull$$$0(6);
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return this.myParameterList;
    }

    @Override
    public String getQualifiedName() {
        String qualifiedName;
        PsiClass containingClass = this.myRefMember.getContainingClass();
        if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            return qualifiedName + '.' + this.myRefMember.getName();
        }
        return this.myRefMember.getName();
    }

    @Override
    public String getReferenceName() {
        return this.getQualifiedName();
    }

    @Override
    public String getText() {
        return this.myRefMember.getName() + this.getParameterList().getText();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String name = this.getQualifiedName();
        if (name == null) {
            if (null == null) {
                LightMemberReference.$$$reportNull$$$0(7);
            }
            return null;
        }
        PsiType[] types2 = this.getTypeParameters();
        if (types2.length == 0) {
            String string = name;
            if (string == null) {
                LightMemberReference.$$$reportNull$$$0(8);
            }
            return string;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        buf.append('<');
        for (int i = 0; i < types2.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types2[i].getCanonicalText());
        }
        buf.append('>');
        String string = buf.toString();
        if (string == null) {
            LightMemberReference.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public PsiElement copy() {
        return new LightMemberReference(this.myManager, this.myRefMember, this.mySubstitutor);
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            LightMemberReference.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LightMemberReference.$$$reportNull$$$0(11);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightMemberReference.$$$reportNull$$$0(12);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "LightClassReference:" + this.myRefMember.getName();
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            LightMemberReference.$$$reportNull$$$0(13);
        }
        return element instanceof PsiClass && element.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = new TextRange(0, this.getTextLength());
        if (textRange == null) {
            LightMemberReference.$$$reportNull$$$0(14);
        }
        return textRange;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        LightMemberReference lightMemberReference = this;
        if (lightMemberReference == null) {
            LightMemberReference.$$$reportNull$$$0(15);
        }
        return lightMemberReference;
    }

    @Override
    public boolean isValid() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList != null && !parameterList.isValid()) {
            return false;
        }
        return this.myRefMember == null || this.myRefMember.isValid();
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        PsiType[] psiTypeArray = parameterList == null ? PsiType.EMPTY_ARRAY : parameterList.getTypeArguments();
        if (psiTypeArray == null) {
            LightMemberReference.$$$reportNull$$$0(16);
        }
        return psiTypeArray;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightMemberReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightMemberReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

