/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.ArtifactOrigin;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.DownloadReport;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.DownloadOptions;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.ResolveData;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search.ModuleEntry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search.OrganisationEntry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search.RevisionEntry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.ResolverSettings;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.URLResolver;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IvyRepResolver
extends URLResolver {
    public static final String DEFAULT_IVYPATTERN = "[organisation]/[module]/ivy-[revision].xml";
    public static final String DEFAULT_IVYROOT = "http://ivyrep.jayasoft.org/";
    private String ivyroot = null;
    private String ivypattern = null;
    private String artroot = null;
    private String artpattern = null;

    private void ensureArtifactConfigured(ResolverSettings settings) {
        if (settings != null && (this.artroot == null || this.artpattern == null)) {
            if (this.artroot == null) {
                String root = settings.getVariable("ivy.ivyrep.default.artifact.root");
                if (root != null) {
                    this.artroot = root;
                } else {
                    settings.configureRepositories(true);
                    this.artroot = settings.getVariable("ivy.ivyrep.default.artifact.root");
                }
            }
            if (this.artpattern == null) {
                String pattern = settings.getVariable("ivy.ivyrep.default.artifact.pattern");
                if (pattern != null) {
                    this.artpattern = pattern;
                } else {
                    settings.configureRepositories(false);
                    this.artpattern = settings.getVariable("ivy.ivyrep.default.artifact.pattern");
                }
            }
            this.updateWholeArtPattern();
        }
    }

    private void ensureIvyConfigured(ResolverSettings settings) {
        if (settings != null && (this.ivyroot == null || this.ivypattern == null)) {
            if (this.ivyroot == null) {
                String root = settings.getVariable("ivy.ivyrep.default.ivy.root");
                if (root != null) {
                    this.ivyroot = root;
                } else {
                    throw new IllegalStateException("ivyroot is mandatory on IvyRepResolver. Make sure to set it in your settings, before setting ivypattern if you wish to set ivypattern too.");
                }
            }
            if (this.ivypattern == null) {
                String pattern = settings.getVariable("ivy.ivyrep.default.ivy.pattern");
                if (pattern != null) {
                    this.ivypattern = pattern;
                } else {
                    settings.configureRepositories(false);
                    this.ivypattern = settings.getVariable("ivy.ivyrep.default.ivy.pattern");
                }
            }
            this.updateWholeIvyPattern();
        }
    }

    private String getWholeIvyPattern() {
        if (this.ivyroot == null || this.ivypattern == null) {
            return null;
        }
        return this.ivyroot + this.ivypattern;
    }

    private String getWholeArtPattern() {
        return this.artroot + this.artpattern;
    }

    public String getIvypattern() {
        return this.ivypattern;
    }

    public void setIvypattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this.ivypattern = pattern;
        this.ensureIvyConfigured(this.getSettings());
        this.updateWholeIvyPattern();
    }

    public String getIvyroot() {
        return this.ivyroot;
    }

    public void setIvyroot(String root) {
        if (root == null) {
            throw new NullPointerException("root must not be null");
        }
        this.ivyroot = !root.endsWith("/") ? root + "/" : root;
        this.ensureIvyConfigured(this.getSettings());
        this.updateWholeIvyPattern();
    }

    @Override
    public void setM2compatible(boolean m2compatible) {
        if (m2compatible) {
            throw new IllegalArgumentException("ivyrep does not support maven2 compatibility. Please use ibiblio resolver instead, or even url or filesystem resolvers for more specific needs.");
        }
    }

    private void updateWholeIvyPattern() {
        this.setIvyPatterns(Collections.singletonList(this.getWholeIvyPattern()));
    }

    private void updateWholeArtPattern() {
        this.setArtifactPatterns(Collections.singletonList(this.getWholeArtPattern()));
    }

    public void publish(Artifact artifact, File src) {
        throw new UnsupportedOperationException("publish not supported by IBiblioResolver");
    }

    public String getArtroot() {
        return this.artroot;
    }

    public String getArtpattern() {
        return this.artpattern;
    }

    public void setArtpattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this.artpattern = pattern;
        this.ensureArtifactConfigured(this.getSettings());
        this.updateWholeArtPattern();
    }

    public void setArtroot(String root) {
        if (root == null) {
            throw new NullPointerException("root must not be null");
        }
        this.artroot = !root.endsWith("/") ? root + "/" : root;
        this.ensureArtifactConfigured(this.getSettings());
        this.updateWholeArtPattern();
    }

    @Override
    public OrganisationEntry[] listOrganisations() {
        this.ensureIvyConfigured(this.getSettings());
        try {
            URL content = new URL(this.ivyroot + "content.xml");
            final ArrayList ret = new ArrayList();
            XMLHelper.parse(content, null, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String org;
                    if ("organisation".equals(qName) && (org = attributes.getValue("name")) != null) {
                        ret.add(new OrganisationEntry(IvyRepResolver.this, org));
                    }
                }
            });
            return ret.toArray(new OrganisationEntry[ret.size()]);
        }
        catch (MalformedURLException content) {
        }
        catch (Exception e) {
            Message.warn("unable to parse content.xml file on ivyrep", e);
        }
        return super.listOrganisations();
    }

    @Override
    public ModuleEntry[] listModules(OrganisationEntry org) {
        this.ensureIvyConfigured(this.getSettings());
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", org.getOrganisation());
        Collection names = this.findIvyNames(tokenValues, "module");
        ModuleEntry[] ret = new ModuleEntry[names.size()];
        int i = 0;
        for (String name : names) {
            ret[i] = new ModuleEntry(org, name);
            ++i;
        }
        return ret;
    }

    @Override
    public RevisionEntry[] listRevisions(ModuleEntry mod) {
        this.ensureIvyConfigured(this.getSettings());
        this.ensureArtifactConfigured(this.getSettings());
        return super.listRevisions(mod);
    }

    @Override
    public String getTypeName() {
        return "ivyrep";
    }

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        this.ensureIvyConfigured(data.getSettings());
        return super.getDependency(dd, data);
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        this.ensureArtifactConfigured(this.getSettings());
        return super.findArtifactRef(artifact, date);
    }

    @Override
    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        this.ensureArtifactConfigured(this.getSettings());
        return super.download(artifacts, options);
    }

    @Override
    public boolean exists(Artifact artifact) {
        this.ensureArtifactConfigured(this.getSettings());
        return super.exists(artifact);
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        this.ensureArtifactConfigured(this.getSettings());
        return super.locate(artifact);
    }

    @Override
    public List getIvyPatterns() {
        this.ensureIvyConfigured(this.getSettings());
        return super.getIvyPatterns();
    }

    @Override
    public List getArtifactPatterns() {
        this.ensureArtifactConfigured(this.getSettings());
        return super.getArtifactPatterns();
    }
}

