/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.script.CliScriptDefinitionProvider;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.script.ScriptDefinitionsSource;
import org.jetbrains.kotlin.script.StandardScriptDefinition;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eJ\u0014\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/common/script/CliScriptDefinitionProvider;", "Lorg/jetbrains/kotlin/script/LazyScriptDefinitionProvider;", "()V", "currentDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "definitions", "", "definitionsFromSources", "setScriptDefinitions", "", "newDefinitions", "", "setScriptDefinitionsSources", "newSources", "Lorg/jetbrains/kotlin/script/ScriptDefinitionsSource;", "cli"})
public final class CliScriptDefinitionProvider
extends LazyScriptDefinitionProvider {
    private final List<Sequence<KotlinScriptDefinition>> definitionsFromSources;
    private final List<KotlinScriptDefinition> definitions;
    @NotNull
    private final Sequence<KotlinScriptDefinition> currentDefinitions;

    @Override
    @NotNull
    protected Sequence<KotlinScriptDefinition> getCurrentDefinitions() {
        return this.currentDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setScriptDefinitions(@NotNull List<? extends KotlinScriptDefinition> newDefinitions) {
        int n;
        Intrinsics.checkParameterIsNotNull(newDefinitions, "newDefinitions");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.definitions.clear();
            n4 = this.definitions.addAll((Collection<KotlinScriptDefinition>)newDefinitions) ? 1 : 0;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setScriptDefinitionsSources(@NotNull List<? extends ScriptDefinitionsSource> newSources) {
        int n;
        Intrinsics.checkParameterIsNotNull(newSources, "newSources");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.definitionsFromSources.clear();
            for (ScriptDefinitionsSource scriptDefinitionsSource : newSources) {
                this.definitionsFromSources.add(SequencesKt.constrainOnce(scriptDefinitionsSource.getDefinitions()));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public CliScriptDefinitionProvider() {
        CliScriptDefinitionProvider cliScriptDefinitionProvider = this;
        ArrayList arrayList = new ArrayList();
        cliScriptDefinitionProvider.definitionsFromSources = arrayList;
        this.definitions = CollectionsKt.arrayListOf(StandardScriptDefinition.INSTANCE);
        this.currentDefinitions = SequencesKt.plus(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this.definitionsFromSources), currentDefinitions.1.INSTANCE), CollectionsKt.asSequence((Iterable)this.definitions));
    }
}

