/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputMessageUtil {
    @NotNull
    public static String renderException(@NotNull Throwable e) {
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        return out.toString();
    }

    @NotNull
    public static String formatOutputMessage(Collection<File> sourceFiles2, File outputFile) {
        return "Output:\n" + outputFile.getPath() + "\n" + "Sources:" + "\n" + StringUtil.join(sourceFiles2, "\n");
    }

    @Nullable
    public static Output parseOutputMessage(@NotNull String message) {
        String[] strings = message.split("\n");
        if (strings.length <= 2) {
            return null;
        }
        if (!"Output:".equals(strings[0])) {
            return null;
        }
        if ("Sources:".equals(strings[1])) {
            return new Output(OutputMessageUtil.parseSourceFiles(strings, 2), null);
        }
        File outputFile = new File(strings[1]);
        if (!"Sources:".equals(strings[2])) {
            return null;
        }
        return new Output(OutputMessageUtil.parseSourceFiles(strings, 3), outputFile);
    }

    private static Collection<File> parseSourceFiles(String[] strings, int start) {
        ArrayList<File> sourceFiles2 = ContainerUtil.newArrayList();
        for (int i = start; i < strings.length; ++i) {
            sourceFiles2.add(new File(strings[i]));
        }
        return sourceFiles2;
    }

    public static class Output
    implements Serializable {
        @NotNull
        public final Collection<File> sourceFiles;
        @Nullable
        public final File outputFile;

        public Output(@NotNull Collection<File> sourceFiles2, @Nullable File outputFile) {
            this.sourceFiles = sourceFiles2;
            this.outputFile = outputFile;
        }
    }
}

