/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");
    private static String ourHomePath;
    private static String[] ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourPluginsPath;

    @NotNull
    public static String getHomePath() {
        if (ourHomePath != null) {
            String string = ourHomePath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(0);
            }
            return string;
        }
        String fromProperty = System.getProperty("idea.home.path", System.getProperty("idea.home"));
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else {
            ourHomePath = PathManager.getHomePathFor(PathManager.class);
            if (ourHomePath == null) {
                String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
        }
        if (SystemInfo.isWindows) {
            ourHomePath = PathManager.canonicalPath(ourHomePath);
        }
        ourBinDirectories = PathManager.getBinDirectories(new File(ourHomePath));
        String string = ourHomePath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass2) {
        String rootPath;
        if (aClass2 == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass2, "/" + aClass2.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        File root2 = new File(rootPath).getAbsoluteFile();
        while ((root2 = root2.getParentFile()) != null && !PathManager.isIdeaHome(root2)) {
        }
        return root2 != null ? root2.getPath() : null;
    }

    private static boolean isIdeaHome(File root2) {
        for (String binDir : PathManager.getBinDirectories(root2)) {
            if (!new File(binDir, "idea.properties").isFile()) continue;
            return true;
        }
        return false;
    }

    private static String[] getBinDirectories(File root2) {
        List<String> binDirs = ContainerUtil.newSmartList();
        String[] subDirs = new String[]{"bin", "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            File dir = new File(root2, subDir);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
            dir = new File(dir, osSuffix);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
        }
        return ArrayUtil.toStringArray(binDirs);
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + File.separator + "bin";
        if (string == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        PathManager.getHomePath();
        for (String binDir : ourBinDirectories) {
            File file2 = new File(binDir, fileName);
            if (!file2.isFile()) continue;
            return file2;
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        File file2;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(6);
        }
        if ((file2 = PathManager.findBinFile(fileName)) != null) {
            File file3 = file2;
            if (file3 == null) {
                PathManager.$$$reportNull$$$0(7);
            }
            return file3;
        }
        String paths = StringUtil.join(ourBinDirectories, "\n");
        throw new FileNotFoundException(String.format("'%s' not found in directories:\n%s", fileName, paths));
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + File.separatorChar + "plugins";
        if (string == null) {
            PathManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(10);
            }
            return string;
        }
        ourConfigPath = System.getProperty("idea.config.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.config.path"))) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + "config");
        String string = ourConfigPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(14);
        }
        String string = PathManager.platformPath(selector, "Library/Preferences", "config");
        if (string == null) {
            PathManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(19);
            }
            return string;
        }
        ourPluginsPath = System.getProperty("idea.plugins.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.plugins.path"))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + File.separator + "Library/Application Support" + File.separator + PATHS_SELECTOR : PathManager.getConfigPath() + File.separatorChar + "plugins");
        String string = ourPluginsPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(23);
            }
            return string;
        }
        ourSystemPath = System.getProperty("idea.system.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.system.path"))) : (PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Caches", "system") : PathManager.getHomePath() + File.separator + "system");
        FileUtil.createDirectory(new File(ourSystemPath));
        String string = ourSystemPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static File getIndexRoot() {
        File indexRoot = new File(System.getProperty("index_root_path", PathManager.getSystemPath() + "/index"));
        FileUtil.createDirectory(indexRoot);
        File file2 = indexRoot;
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        return file2;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context, String path2) {
        URL url;
        if (context == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        if ((url = context.getResource(path2)) == null) {
            url = ClassLoader.getSystemResource(path2.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path2) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        Pair<String, String> paths;
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path2 = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path2.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path2.substring(0, path2.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol) && (paths = URLUtil.splitJarUrl(resourceURL.getFile())) != null && paths.first != null) {
            resultPath = FileUtil.toSystemDependentName((String)paths.first);
        }
        if (resultPath == null) {
            PathManager.log("cannot extract: " + resourcePath + " from " + resourceURL);
            return null;
        }
        return StringUtil.trimEnd(resultPath, File.separator);
    }

    private static void log(String x) {
        System.err.println(x);
    }

    public static String getAbsolutePath(String path2) {
        path2 = FileUtil.expandUserHome(path2);
        return FileUtil.toCanonicalPath(new File(path2).getAbsolutePath());
    }

    private static String trimPathQuotes(String path2) {
        if (path2 != null && path2.length() >= 3 && StringUtil.startsWithChar(path2, '\"') && StringUtil.endsWithChar(path2, '\"')) {
            path2 = path2.substring(1, path2.length() - 1);
        }
        return path2;
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @NotNull String fallback) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        return PathManager.platformPath(selector, macPart, null, null, null, fallback);
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @Nullable String winVar, @Nullable String xdgVar, @Nullable String xdgDir, @NotNull String fallback) {
        String dir;
        if (selector == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(39);
        }
        if (macPart != null && SystemInfo.isMac) {
            return SystemProperties.getUserHome() + File.separator + macPart + File.separator + selector;
        }
        if (winVar != null && SystemInfo.isWindows && (dir = System.getenv(winVar)) != null) {
            return dir + File.separator + selector;
        }
        if (xdgVar != null && xdgDir != null && SystemInfo.hasXdgOpen()) {
            dir = System.getenv(xdgVar);
            if (dir == null) {
                dir = SystemProperties.getUserHome() + File.separator + xdgDir;
            }
            return dir + File.separator + selector;
        }
        return SystemProperties.getUserHome() + File.separator + "." + selector + (!fallback.isEmpty() ? File.separator + fallback : "");
    }

    private static String canonicalPath(String path2) {
        try {
            return new File(path2).getCanonicalPath();
        }
        catch (IOException e) {
            return path2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: 
            case 21: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtilClassPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "platformPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

