/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"checkClassifierUsages", "", "declarations", "", "Lcom/intellij/psi/PsiElement;", "checkers", "", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
public final class ClassifierUsageCheckerKt {
    public static final void checkClassifierUsages(@NotNull Collection<? extends PsiElement> declarations, @NotNull Iterable<? extends ClassifierUsageChecker> checkers, @NotNull ClassifierUsageCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(declarations, "declarations");
        Intrinsics.checkParameterIsNotNull(checkers, "checkers");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtTreeVisitorVoid visitor2 = new KtTreeVisitorVoid(checkers, context){
            final /* synthetic */ Iterable $checkers;
            final /* synthetic */ ClassifierUsageCheckerContext $context;

            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                block4: {
                    ClassifierDescriptor classifierDescriptor;
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    super.visitReferenceExpression(expression2);
                    if (expression2 instanceof KtNameReferenceExpression && Intrinsics.areEqual(((KtNameReferenceExpression)expression2).getReferencedNameElementType(), KtTokens.SUPER_KEYWORD)) {
                        return;
                    }
                    ClassifierDescriptor classifierDescriptor2 = this.getReferencedClassifier(expression2);
                    if (classifierDescriptor2 == null) {
                        return;
                    }
                    ClassifierDescriptor target = classifierDescriptor2;
                    this.runCheckersWithTarget(target, expression2);
                    ClassifierDescriptor classifierDescriptor3 = this.getReferenceToCompanionViaClassifier(expression2, target);
                    if (classifierDescriptor3 == null) break block4;
                    ClassifierDescriptor referenceClassifier = classifierDescriptor = classifierDescriptor3;
                    DeclarationDescriptor declarationDescriptor = target.getContainingDeclaration();
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    ClassDescriptor outerClass2 = (ClassDescriptor)declarationDescriptor;
                    this.runCheckersWithTarget(outerClass2, expression2);
                    if (referenceClassifier instanceof TypeAliasDescriptor) {
                        this.runCheckersWithTarget(referenceClassifier, expression2);
                    }
                }
            }

            private final void runCheckersWithTarget(ClassifierDescriptor target, KtReferenceExpression expression2) {
                for (ClassifierUsageChecker checker : this.$checkers) {
                    checker.check(target, expression2, this.$context);
                }
            }

            private final ClassifierDescriptor getReferencedClassifier(KtReferenceExpression expression2) {
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Collection targets;
                DeclarationDescriptor target = (DeclarationDescriptor)this.$context.getTrace().get(BindingContext.REFERENCE_TARGET, expression2);
                if (target instanceof ClassifierDescriptor) {
                    return (ClassifierDescriptor)target;
                }
                if (target instanceof ClassConstructorDescriptor) {
                    return ((ClassConstructorDescriptor)target).getConstructedClass();
                }
                Collection collection = (Collection)this.$context.getTrace().get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression2);
                if (collection == null) {
                    return null;
                }
                Collection collection2 = targets = collection;
                Intrinsics.checkExpressionValueIsNotNull(collection2, "targets");
                Iterable iterable = $receiver$iv = (Iterable)collection2;
                Object destination$iv$iv = new LinkedHashMap<K, V>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    Object object;
                    DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                    DeclarationDescriptor declarationDescriptor = it;
                    if (!(declarationDescriptor instanceof DeclarationDescriptorWithSource)) {
                        declarationDescriptor = null;
                    }
                    DeclarationDescriptorWithSource declarationDescriptorWithSource = (DeclarationDescriptorWithSource)declarationDescriptor;
                    Object $receiver$iv$iv$iv = destination$iv$iv;
                    SourceElement key$iv$iv = declarationDescriptorWithSource != null ? declarationDescriptorWithSource.getSource() : null;
                    V value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        ArrayList<E> answer$iv$iv$iv = new ArrayList<E>();
                        $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                if (destination$iv$iv.size() != 1) {
                    return null;
                }
                $receiver$iv$iv = $receiver$iv = (Iterable)targets;
                destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof ClassifierDescriptor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (ClassifierDescriptor)CollectionsKt.singleOrNull((List)destination$iv$iv);
            }

            private final ClassifierDescriptor getReferenceToCompanionViaClassifier(KtReferenceExpression expression2, ClassifierDescriptor target) {
                if (!DescriptorUtils.isCompanionObject(target)) {
                    return null;
                }
                return (ClassifierDescriptor)this.$context.getTrace().get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, expression2);
            }
            {
                this.$checkers = $captured_local_variable$0;
                this.$context = $captured_local_variable$1;
            }
        };
        for (PsiElement psiElement : declarations) {
            psiElement.accept(visitor2);
        }
    }
}

