/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasCondition;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatchScope;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsCatch
extends SourceInfoAwareJsNode
implements HasCondition {
    protected final JsCatchScope scope;
    private JsBlock body;
    private JsExpression condition;
    private JsParameter param;

    public JsCatch(@NotNull JsName name) {
        this.param = new JsParameter(name);
        this.scope = null;
    }

    public JsCatch(JsScope parent2, @NotNull String ident) {
        assert (parent2 != null);
        this.scope = new JsCatchScope(parent2, ident);
        this.param = new JsParameter(this.scope.findName(ident));
    }

    public JsCatch(JsScope parent2, @NotNull String ident, @NotNull JsStatement catchBody) {
        this(parent2, ident);
        this.body = catchBody instanceof JsBlock ? (JsBlock)catchBody : new JsBlock(catchBody);
    }

    public JsBlock getBody() {
        return this.body;
    }

    @Override
    public JsExpression getCondition() {
        return this.condition;
    }

    public JsParameter getParameter() {
        return this.param;
    }

    public JsScope getScope() {
        return this.scope;
    }

    public void setBody(JsBlock body) {
        this.body = body;
    }

    @Override
    public void setCondition(JsExpression condition) {
        this.condition = condition;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitCatch(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.param);
        if (this.condition != null) {
            visitor2.accept(this.condition);
        }
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.param = v.accept(this.param);
            if (this.condition != null) {
                this.condition = v.accept(this.condition);
            }
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsCatch deepCopy() {
        JsCatchScope scopeCopy = this.scope != null ? this.scope.copy() : null;
        JsBlock bodyCopy = AstUtil.deepCopy(this.body);
        JsExpression conditionCopy = AstUtil.deepCopy(this.condition);
        JsParameter paramCopy = AstUtil.deepCopy(this.param);
        return new JsCatch(scopeCopy, bodyCopy, conditionCopy, paramCopy).withMetadataFrom(this);
    }

    private JsCatch(JsCatchScope scope, JsBlock body, JsExpression condition, JsParameter param) {
        this.scope = scope;
        this.body = body;
        this.condition = condition;
        this.param = param;
    }
}

