/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;

public abstract class DiagnosticFactory<D extends Diagnostic> {
    private String name = null;
    private final Severity severity;

    protected DiagnosticFactory(@NotNull Severity severity) {
        this.severity = severity;
    }

    protected DiagnosticFactory(@NotNull String name, @NotNull Severity severity) {
        this.name = name;
        this.severity = severity;
    }

    void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    @NotNull
    public D cast(@NotNull Diagnostic diagnostic) {
        if (diagnostic.getFactory() != this) {
            throw new IllegalArgumentException("Factory mismatch: expected " + this + " but was " + diagnostic.getFactory());
        }
        return (D)diagnostic;
    }

    @NotNull
    public static <D extends Diagnostic> D cast(@NotNull Diagnostic diagnostic, DiagnosticFactory<? extends D> ... factories) {
        return DiagnosticFactory.cast(diagnostic, Arrays.asList(factories));
    }

    @NotNull
    public static <D extends Diagnostic> D cast(@NotNull Diagnostic diagnostic, @NotNull Collection<? extends DiagnosticFactory<? extends D>> factories) {
        for (DiagnosticFactory<D> factory2 : factories) {
            if (diagnostic.getFactory() != factory2) continue;
            return factory2.cast(diagnostic);
        }
        throw new IllegalArgumentException("Factory mismatch: expected one of " + factories + " but was " + diagnostic.getFactory());
    }

    public String toString() {
        return this.getName();
    }
}

