/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import com.google.common.collect.ImmutableList;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayConstructor;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayGet;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayIterator;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayOf;
import org.jetbrains.kotlin.codegen.intrinsics.ArraySet;
import org.jetbrains.kotlin.codegen.intrinsics.ArraySize;
import org.jetbrains.kotlin.codegen.intrinsics.BinaryOp;
import org.jetbrains.kotlin.codegen.intrinsics.Clone;
import org.jetbrains.kotlin.codegen.intrinsics.CompareTo;
import org.jetbrains.kotlin.codegen.intrinsics.Concat;
import org.jetbrains.kotlin.codegen.intrinsics.Equals;
import org.jetbrains.kotlin.codegen.intrinsics.EqualsThrowingNpeForNullReceiver;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.intrinsics.Increment;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicsMap;
import org.jetbrains.kotlin.codegen.intrinsics.Inv;
import org.jetbrains.kotlin.codegen.intrinsics.IsArrayOf;
import org.jetbrains.kotlin.codegen.intrinsics.IteratorNext;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KCallableNameProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KClassJavaProperty;
import org.jetbrains.kotlin.codegen.intrinsics.LateinitIsInitialized;
import org.jetbrains.kotlin.codegen.intrinsics.MonitorInstruction;
import org.jetbrains.kotlin.codegen.intrinsics.NewArray;
import org.jetbrains.kotlin.codegen.intrinsics.Not;
import org.jetbrains.kotlin.codegen.intrinsics.NumberCast;
import org.jetbrains.kotlin.codegen.intrinsics.RangeTo;
import org.jetbrains.kotlin.codegen.intrinsics.StringGetChar;
import org.jetbrains.kotlin.codegen.intrinsics.StringPlus;
import org.jetbrains.kotlin.codegen.intrinsics.ToString;
import org.jetbrains.kotlin.codegen.intrinsics.UnaryMinus;
import org.jetbrains.kotlin.codegen.intrinsics.UnaryPlus;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.org.objectweb.asm.Type;

public class IntrinsicMethods {
    public static final String INTRINSICS_CLASS_NAME = "kotlin/jvm/internal/Intrinsics";
    private static final FqName KOTLIN_JVM = new FqName("kotlin.jvm");
    static final FqNameUnsafe RECEIVER_PARAMETER_FQ_NAME = new FqNameUnsafe("T");
    private static final IntrinsicMethod UNARY_MINUS = new UnaryMinus();
    private static final IntrinsicMethod UNARY_PLUS = new UnaryPlus();
    private static final IntrinsicMethod NUMBER_CAST = new NumberCast();
    private static final IntrinsicMethod INV = new Inv();
    private static final IntrinsicMethod RANGE_TO = new RangeTo();
    private static final IntrinsicMethod INC = new Increment(1);
    private static final IntrinsicMethod DEC = new Increment(-1);
    private static final IntrinsicMethod ARRAY_SIZE = new ArraySize();
    private static final Equals EQUALS = new Equals();
    private static final IteratorNext ITERATOR_NEXT = new IteratorNext();
    private static final ArraySet ARRAY_SET = new ArraySet();
    private static final ArrayGet ARRAY_GET = new ArrayGet();
    private static final StringPlus STRING_PLUS = new StringPlus();
    private static final ToString TO_STRING = new ToString();
    private static final Clone CLONE = new Clone();
    private static final IntrinsicMethod ARRAY_ITERATOR = new ArrayIterator();
    private final IntrinsicsMap intrinsicsMap = new IntrinsicsMap();

    public IntrinsicMethods(JvmTarget jvmTarget) {
        this(jvmTarget, true);
    }

    public IntrinsicMethods(JvmTarget jvmTarget, boolean shouldThrowNpeOnExplicitEqualsForBoxedNull) {
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, RECEIVER_PARAMETER_FQ_NAME, "javaClass", -1, JavaClassProperty.INSTANCE);
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, KotlinBuiltIns.FQ_NAMES.kClass, "java", -1, new KClassJavaProperty());
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.FQ_NAMES.kCallable.toSafe(), null, "name", -1, new KCallableNameProperty());
        this.intrinsicsMap.registerIntrinsic(new FqName("kotlin.jvm.internal.unsafe"), null, "monitorEnter", 1, MonitorInstruction.MONITOR_ENTER);
        this.intrinsicsMap.registerIntrinsic(new FqName("kotlin.jvm.internal.unsafe"), null, "monitorExit", 1, MonitorInstruction.MONITOR_EXIT);
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, KotlinBuiltIns.FQ_NAMES.array, "isArrayOf", 0, new IsArrayOf());
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.kProperty0, "isInitialized", -1, LateinitIsInitialized.INSTANCE);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, null, "arrayOf", 1, new ArrayOf());
        ImmutableList<Name> primitiveCastMethods = OperatorConventions.NUMBER_CONVERSIONS.asList();
        for (Name method : primitiveCastMethods) {
            String methodName = method.asString();
            this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES.number, methodName, 0, NUMBER_CAST);
            for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
                this.declareIntrinsicFunction(type2.getTypeFqName(), methodName, 0, NUMBER_CAST);
            }
        }
        for (PrimitiveType type3 : PrimitiveType.NUMBER_TYPES) {
            FqName typeFqName = type3.getTypeFqName();
            this.declareIntrinsicFunction(typeFqName, "plus", 0, UNARY_PLUS);
            this.declareIntrinsicFunction(typeFqName, "unaryPlus", 0, UNARY_PLUS);
            this.declareIntrinsicFunction(typeFqName, "minus", 0, UNARY_MINUS);
            this.declareIntrinsicFunction(typeFqName, "unaryMinus", 0, UNARY_MINUS);
            this.declareIntrinsicFunction(typeFqName, "inv", 0, INV);
            this.declareIntrinsicFunction(typeFqName, "rangeTo", 1, RANGE_TO);
            this.declareIntrinsicFunction(typeFqName, "inc", 0, INC);
            this.declareIntrinsicFunction(typeFqName, "dec", 0, DEC);
        }
        HashCode hashCode = new HashCode(jvmTarget);
        for (PrimitiveType type2 : PrimitiveType.values()) {
            IntrinsicMethod equalsMethod;
            FqName typeFqName = type2.getTypeFqName();
            if (shouldThrowNpeOnExplicitEqualsForBoxedNull) {
                Type wrapperType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(JvmPrimitiveType.get(type2).getWrapperFqName());
                equalsMethod = new EqualsThrowingNpeForNullReceiver(wrapperType);
            } else {
                equalsMethod = EQUALS;
            }
            this.declareIntrinsicFunction(typeFqName, "equals", 1, equalsMethod);
            this.declareIntrinsicFunction(typeFqName, "hashCode", 0, (IntrinsicMethod)hashCode);
            this.declareIntrinsicFunction(typeFqName, "toString", 0, (IntrinsicMethod)TO_STRING);
            this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, null, StringsKt.decapitalize(type2.getArrayTypeName().asString()) + "Of", 1, new ArrayOf());
        }
        this.declareBinaryOp("plus", 96);
        this.declareBinaryOp("minus", 100);
        this.declareBinaryOp("times", 104);
        this.declareBinaryOp("div", 108);
        this.declareBinaryOp("mod", 112);
        this.declareBinaryOp("rem", 112);
        this.declareBinaryOp("shl", 120);
        this.declareBinaryOp("shr", 122);
        this.declareBinaryOp("ushr", 124);
        this.declareBinaryOp("and", 126);
        this.declareBinaryOp("or", 128);
        this.declareBinaryOp("xor", 130);
        this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES._boolean, "not", 0, (IntrinsicMethod)new Not());
        this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES.string, "plus", 1, (IntrinsicMethod)new Concat());
        this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES.string, "get", 1, (IntrinsicMethod)new StringGetChar());
        this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES.cloneable, "clone", 0, (IntrinsicMethod)CLONE);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.any, "toString", 0, TO_STRING);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.string, "plus", 1, STRING_PLUS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, null, "arrayOfNulls", 1, new NewArray());
        for (PrimitiveType type2 : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type2.getTypeFqName(), "compareTo", 1, (IntrinsicMethod)new CompareTo());
            this.declareIntrinsicFunction(KotlinBuiltIns.COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier(type2.getTypeName().asString() + "Iterator")), "next", 0, (IntrinsicMethod)ITERATOR_NEXT);
        }
        this.declareArrayMethods();
    }

    private void declareArrayMethods() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            this.declareArrayMethods(jvmPrimitiveType.getPrimitiveType().getArrayTypeFqName());
        }
        this.declareArrayMethods(KotlinBuiltIns.FQ_NAMES.array.toSafe());
    }

    private void declareArrayMethods(@NotNull FqName arrayTypeFqName) {
        this.declareIntrinsicFunction(arrayTypeFqName, "size", -1, ARRAY_SIZE);
        this.declareIntrinsicFunction(arrayTypeFqName, "set", 2, (IntrinsicMethod)ARRAY_SET);
        this.declareIntrinsicFunction(arrayTypeFqName, "get", 1, (IntrinsicMethod)ARRAY_GET);
        this.declareIntrinsicFunction(arrayTypeFqName, "clone", 0, (IntrinsicMethod)CLONE);
        this.declareIntrinsicFunction(arrayTypeFqName, "iterator", 0, ARRAY_ITERATOR);
        this.declareIntrinsicFunction(arrayTypeFqName, "<init>", 2, (IntrinsicMethod)ArrayConstructor.INSTANCE);
    }

    private void declareBinaryOp(@NotNull String methodName, int opcode) {
        BinaryOp op = new BinaryOp(opcode);
        for (PrimitiveType type2 : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type2.getTypeFqName(), methodName, 1, (IntrinsicMethod)op);
        }
    }

    private void declareIntrinsicFunction(@NotNull FqName classFqName, @NotNull String methodName, int arity, @NotNull IntrinsicMethod implementation) {
        this.intrinsicsMap.registerIntrinsic(classFqName, null, methodName, arity, implementation);
    }

    private void declareIntrinsicFunction(@NotNull FqNameUnsafe classFqName, @NotNull String methodName, int arity, @NotNull IntrinsicMethod implementation) {
        this.intrinsicsMap.registerIntrinsic(classFqName.toSafe(), null, methodName, arity, implementation);
    }

    @Nullable
    public IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor2) {
        return this.intrinsicsMap.getIntrinsic(descriptor2);
    }
}

