/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\b\t\nJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "", "renderClassifier", "", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "FULLY_QUALIFIED", "SHORT", "SOURCE_CODE_QUALIFIED", "descriptors"})
public interface ClassifierNamePolicy {
    @NotNull
    public String renderClassifier(@NotNull ClassifierDescriptor var1, @NotNull DescriptorRenderer var2);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy$SHORT;", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "()V", "renderClassifier", "", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "descriptors"})
    public static final class SHORT
    implements ClassifierNamePolicy {
        public static final SHORT INSTANCE;

        @Override
        @NotNull
        public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
            Intrinsics.checkParameterIsNotNull(classifier2, "classifier");
            Intrinsics.checkParameterIsNotNull(renderer, "renderer");
            if (classifier2 instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifier2).getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "classifier.name");
                return renderer.renderName(name);
            }
            ArrayList<Name> qualifiedNameElements = new ArrayList<Name>();
            DeclarationDescriptor current = classifier2;
            do {
                qualifiedNameElements.add(current.getName());
            } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
            return RenderingUtilsKt.renderFqName(CollectionsKt.asReversedMutable((List)qualifiedNameElements));
        }

        private SHORT() {
        }

        static {
            SHORT sHORT;
            INSTANCE = sHORT = new SHORT();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy$FULLY_QUALIFIED;", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "()V", "renderClassifier", "", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "descriptors"})
    public static final class FULLY_QUALIFIED
    implements ClassifierNamePolicy {
        public static final FULLY_QUALIFIED INSTANCE;

        @Override
        @NotNull
        public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
            Intrinsics.checkParameterIsNotNull(classifier2, "classifier");
            Intrinsics.checkParameterIsNotNull(renderer, "renderer");
            if (classifier2 instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifier2).getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "classifier.name");
                return renderer.renderName(name);
            }
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classifier2);
            Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "DescriptorUtils.getFqName(classifier)");
            return renderer.renderFqName(fqNameUnsafe);
        }

        private FULLY_QUALIFIED() {
        }

        static {
            FULLY_QUALIFIED fULLY_QUALIFIED;
            INSTANCE = fULLY_QUALIFIED = new FULLY_QUALIFIED();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy$SOURCE_CODE_QUALIFIED;", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "()V", "qualifiedNameForSourceCode", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "qualifierName", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "renderClassifier", "classifier", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "descriptors"})
    public static final class SOURCE_CODE_QUALIFIED
    implements ClassifierNamePolicy {
        public static final SOURCE_CODE_QUALIFIED INSTANCE;

        @Override
        @NotNull
        public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
            Intrinsics.checkParameterIsNotNull(classifier2, "classifier");
            Intrinsics.checkParameterIsNotNull(renderer, "renderer");
            return this.qualifiedNameForSourceCode(classifier2);
        }

        private final String qualifiedNameForSourceCode(ClassifierDescriptor descriptor2) {
            Name name = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
            String nameString = RenderingUtilsKt.render(name);
            if (descriptor2 instanceof TypeParameterDescriptor) {
                return nameString;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.containingDeclaration");
            String qualifier = this.qualifierName(declarationDescriptor);
            return qualifier != null && Intrinsics.areEqual(qualifier, "") ^ true ? qualifier + "." + nameString : nameString;
        }

        private final String qualifierName(DeclarationDescriptor descriptor2) {
            String string;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof ClassDescriptor) {
                string = this.qualifiedNameForSourceCode((ClassifierDescriptor)descriptor2);
            } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                FqNameUnsafe fqNameUnsafe = ((PackageFragmentDescriptor)descriptor2).getFqName().toUnsafe();
                Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "descriptor.fqName.toUnsafe()");
                string = RenderingUtilsKt.render(fqNameUnsafe);
            } else {
                string = null;
            }
            return string;
        }

        private SOURCE_CODE_QUALIFIED() {
        }

        static {
            SOURCE_CODE_QUALIFIED sOURCE_CODE_QUALIFIED;
            INSTANCE = sOURCE_CODE_QUALIFIED = new SOURCE_CODE_QUALIFIED();
        }
    }
}

