/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.FileModificationService;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightUtilCore
extends FileModificationService {
    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(8);
        }
        if (outChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(9);
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets, Character.valueOf('\"'), Character.valueOf('\''));
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets, Character ... endChars) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(10);
        }
        if (outChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(11);
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        List<Character> endCharList = Arrays.asList(endChars);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index2 = 0;
        int outOffset = outChars.length();
        while (index2 < chars.length()) {
            char c = chars.charAt(index2++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index2 - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index2;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index2 == chars.length()) {
                return false;
            }
            c = chars.charAt(index2++);
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index2 < chars.length()) {
                        if ('0' <= (c = chars.charAt(index2++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index2 < chars.length()) {
                                if ('0' <= (c = chars.charAt(index2++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                } else {
                                    --index2;
                                }
                            }
                        } else {
                            --index2;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'u': {
                    while (index2 != chars.length() && chars.charAt(index2) == 'u') {
                        ++index2;
                    }
                    if (index2 + 4 <= chars.length()) {
                        try {
                            int code = Integer.parseInt(chars.substring(index2, index2 + 4), 16);
                            if (code == 10 || code == 13) {
                                return false;
                            }
                            c = chars.charAt(index2);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)code);
                            index2 += 4;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    if (endCharList.contains(Character.valueOf(c))) {
                        outChars.append(c);
                        break;
                    }
                    return false;
                }
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index2;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/CodeInsightUtilCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementInRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "forcePsiPostprocessAndRestoreElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStringCharacters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

